/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.mvc.BaseCommandController;

public abstract class AbstractCommandController
extends BaseCommandController {
    private static final String COMMAND_IN_SESSION_PARAMETER = "command-in-session";
    private static final String TRUE = Boolean.TRUE.toString();

    public AbstractCommandController() {
    }

    public AbstractCommandController(Class commandClass) {
        this.setCommandClass(commandClass);
    }

    public AbstractCommandController(Class commandClass, String commandName) {
        this.setCommandClass(commandClass);
        this.setCommandName(commandName);
    }

    protected final ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        Object command = null;
        BindException errors = null;
        if (this.isCommandInSession(request)) {
            this.logger.debug((Object)"Render phase obtaining command and errors objects from session");
            command = this.getRenderCommand(request);
            errors = this.getRenderErrors(request);
        } else {
            this.logger.debug((Object)"Render phase creating new command and errors objects");
        }
        if (command == null) {
            command = this.getCommand((PortletRequest)request);
        }
        if (errors == null) {
            PortletRequestDataBinder binder = this.bindAndValidate((PortletRequest)request, command);
            errors = new BindException(binder.getBindingResult());
        }
        return this.handleRender(request, response, command, errors);
    }

    protected final void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        Object command = this.getCommand((PortletRequest)request);
        PortletRequestDataBinder binder = this.bindAndValidate((PortletRequest)request, command);
        BindException errors = new BindException(binder.getBindingResult());
        this.handleAction(request, response, command, errors);
        this.setRenderCommandAndErrors(request, command, errors);
        this.setCommandInSession(response);
    }

    protected abstract ModelAndView handleRender(RenderRequest var1, RenderResponse var2, Object var3, BindException var4) throws Exception;

    protected abstract void handleAction(ActionRequest var1, ActionResponse var2, Object var3, BindException var4) throws Exception;

    protected String getCommandInSessionParameterName() {
        return COMMAND_IN_SESSION_PARAMETER;
    }

    protected final void setCommandInSession(ActionResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting render parameter [" + this.getCommandInSessionParameterName() + "] to indicate a valid command (and errors) object are in the session"));
        }
        try {
            response.setRenderParameter(this.getCommandInSessionParameterName(), TRUE);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected final boolean isCommandInSession(RenderRequest request) {
        return TRUE.equals(request.getParameter(this.getCommandInSessionParameterName()));
    }
}

