/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.springframework.beans.BeansException;
import org.springframework.web.portlet.handler.HandlerInterceptorAdapter;

public class ParameterMappingInterceptor
extends HandlerInterceptorAdapter {
    public static final String DEFAULT_PARAMETER_NAME = "action";
    private String parameterName = "action";

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void initApplicationContext() throws BeansException {
        if (this.getParameterName() == null) {
            throw new IllegalArgumentException("A parameterName is required");
        }
    }

    public boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws Exception {
        String mappingParameter;
        if (request instanceof ActionRequest && (mappingParameter = request.getParameter(this.getParameterName())) != null) {
            ((ActionResponse)response).setRenderParameter(this.parameterName, mappingParameter);
        }
        return true;
    }
}

