/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

public class PortletContextAwareProcessor
implements BeanPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    public PortletContextAwareProcessor(PortletContext portletContext) {
        this(portletContext, null);
    }

    public PortletContextAwareProcessor(PortletConfig portletConfig) {
        this(null, portletConfig);
    }

    public PortletContextAwareProcessor(PortletContext portletContext, PortletConfig portletConfig) {
        this.portletContext = portletContext;
        this.portletConfig = portletConfig;
        if (portletContext == null && portletConfig != null) {
            this.portletContext = portletConfig.getPortletContext();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof PortletContextAware) {
            if (this.portletContext == null) {
                throw new IllegalStateException("Cannot satisfy PortletContextAware for bean '" + beanName + "' without PortletContext");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking setPortletContext on PortletContextAware bean '" + beanName + "'"));
            }
            ((PortletContextAware)bean).setPortletContext(this.portletContext);
        }
        if (bean instanceof PortletConfigAware) {
            if (this.portletConfig == null) {
                throw new IllegalStateException("Cannot satisfy PortletConfigAware for bean '" + beanName + "' without PortletConfig");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking setPortletConfig on PortletConfigAware bean '" + beanName + "'"));
            }
            ((PortletConfigAware)bean).setPortletConfig(this.portletConfig);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

