/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;

public class RuleBasedTransactionAttribute
extends DefaultTransactionAttribute {
    public static final String PREFIX_ROLLBACK_RULE = "-";
    public static final String PREFIX_COMMIT_RULE = "+";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute == null ? (class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute = RuleBasedTransactionAttribute.class$("org.springframework.transaction.interceptor.RuleBasedTransactionAttribute")) : class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute));
    private List rollbackRules;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute;

    public RuleBasedTransactionAttribute() {
    }

    public RuleBasedTransactionAttribute(RuleBasedTransactionAttribute other) {
        super(other);
        this.rollbackRules = new ArrayList(other.rollbackRules);
    }

    public RuleBasedTransactionAttribute(int propagationBehavior, List rollbackRules) {
        super(propagationBehavior);
        this.rollbackRules = rollbackRules;
    }

    public void setRollbackRules(List rollbackRules) {
        this.rollbackRules = rollbackRules;
    }

    public List getRollbackRules() {
        if (this.rollbackRules == null) {
            this.rollbackRules = new LinkedList();
        }
        return this.rollbackRules;
    }

    public boolean rollbackOn(Throwable ex) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applying rules to determine whether transaction should rollback on " + ex));
        }
        RollbackRuleAttribute winner = null;
        int deepest = Integer.MAX_VALUE;
        if (this.rollbackRules != null) {
            Iterator it = this.rollbackRules.iterator();
            while (it.hasNext()) {
                RollbackRuleAttribute rule = (RollbackRuleAttribute)it.next();
                int depth = rule.getDepth(ex);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                winner = rule;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Winning rollback rule is: " + winner));
        }
        if (winner == null) {
            logger.debug((Object)"No relevant rollback rule found: applying superclass default");
            return super.rollbackOn(ex);
        }
        return !(winner instanceof NoRollbackRuleAttribute);
    }

    public String toString() {
        StringBuffer result = this.getDefinitionDescription();
        if (this.rollbackRules != null) {
            Iterator it = this.rollbackRules.iterator();
            while (it.hasNext()) {
                RollbackRuleAttribute rule = (RollbackRuleAttribute)it.next();
                String sign = rule instanceof NoRollbackRuleAttribute ? PREFIX_COMMIT_RULE : PREFIX_ROLLBACK_RULE;
                result.append(',').append(sign).append(rule.getExceptionName());
            }
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

