/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private Map<Class<?>, List<AnnotatedMember>> classMetadata = new HashMap();
    private Map<String, EntityManagerFactory> entityManagersByName;
    private EntityManagerFactory uniqueEntityManagerFactory;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private synchronized void initMapsIfNecessary() {
        if (this.entityManagersByName == null) {
            this.entityManagersByName = new HashMap<String, EntityManagerFactory>();
            for (String emfName : this.applicationContext.getBeanNamesForType(EntityManagerFactory.class)) {
                EntityManagerFactoryInfo emfi;
                EntityManagerFactory emf = (EntityManagerFactory)this.applicationContext.getBean(emfName);
                if (!(emf instanceof EntityManagerFactoryInfo) || (emfi = (EntityManagerFactoryInfo)emf).getPersistenceUnitName() == null) continue;
                this.entityManagersByName.put(emfi.getPersistenceUnitName(), emf);
            }
            if (this.entityManagersByName.isEmpty()) {
                String[] emfNames = this.applicationContext.getBeanNamesForType(EntityManagerFactory.class);
                if (emfNames.length == 1) {
                    this.uniqueEntityManagerFactory = (EntityManagerFactory)this.applicationContext.getBean(emfNames[0]);
                }
            } else if (this.entityManagersByName.size() == 1) {
                this.uniqueEntityManagerFactory = this.entityManagersByName.values().iterator().next();
            }
            if (this.entityManagersByName.isEmpty() && this.uniqueEntityManagerFactory == null) {
                this.logger.warn((Object)"No named entity manager factories defined and not exactly one anonymous one: cannot inject");
            }
        }
    }

    protected EntityManagerFactory findEntityManagerFactoryByName(String emfName) throws NoSuchBeanDefinitionException {
        this.initMapsIfNecessary();
        if (emfName == null || "".equals(emfName)) {
            if (this.uniqueEntityManagerFactory != null) {
                return this.uniqueEntityManagerFactory;
            }
            throw new NoSuchBeanDefinitionException("No EntityManagerFactory name given and factory contains several");
        }
        EntityManagerFactory namedEmf = this.entityManagersByName.get(emfName);
        if (namedEmf == null) {
            throw new NoSuchBeanDefinitionException("No EntityManagerFactory found for persistence unit name '" + emfName + "'");
        }
        return namedEmf;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        List<AnnotatedMember> metadata = this.findClassMetadata(bean.getClass());
        for (AnnotatedMember member : metadata) {
            member.inject(bean);
        }
        return true;
    }

    private synchronized List<AnnotatedMember> findClassMetadata(Class<? extends Object> clazz) {
        List<AnnotatedMember> metadata = this.classMetadata.get(clazz);
        if (metadata == null) {
            final LinkedList<AnnotatedMember> newMetadata = new LinkedList<AnnotatedMember>();
            ReflectionUtils.doWithFields(clazz, new ReflectionUtils.FieldCallback(){

                public void doWith(Field f) {
                    PersistenceAnnotationBeanPostProcessor.this.addIfPresent(newMetadata, f);
                }
            });
            ReflectionUtils.doWithMethods(clazz, new ReflectionUtils.MethodCallback(){

                public void doWith(Method m) {
                    PersistenceAnnotationBeanPostProcessor.this.addIfPresent(newMetadata, m);
                }
            });
            metadata = newMetadata;
            this.classMetadata.put(clazz, metadata);
        }
        return metadata;
    }

    private void addIfPresent(List<AnnotatedMember> metadata, AccessibleObject ao) {
        PersistenceContext pc = ao.getAnnotation(PersistenceContext.class);
        if (pc != null) {
            metadata.add(new AnnotatedMember(pc.unitName(), pc.type(), ao));
        } else {
            PersistenceUnit pu = ao.getAnnotation(PersistenceUnit.class);
            if (pu != null) {
                metadata.add(new AnnotatedMember(pu.unitName(), null, ao));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedMember {
        private final String unitName;
        private final PersistenceContextType type;
        private final AccessibleObject member;

        public AnnotatedMember(String unitName, PersistenceContextType type, AccessibleObject member) {
            this.unitName = unitName;
            this.type = type;
            this.member = member;
            Class<?> memberType = this.getMemberType();
            if (!EntityManagerFactory.class.isAssignableFrom(memberType) && !EntityManager.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("Cannot inject " + member + ": not a supported JPA type");
            }
        }

        public void inject(Object instance) {
            block6: {
                Object value = this.resolve();
                try {
                    if (!this.member.isAccessible()) {
                        this.member.setAccessible(true);
                    }
                    if (this.member instanceof Field) {
                        ((Field)this.member).set(instance, value);
                        break block6;
                    }
                    if (this.member instanceof Method) {
                        ((Method)this.member).invoke(instance, value);
                        break block6;
                    }
                    throw new IllegalArgumentException("Cannot inject unknown AccessibleObject type " + this.member);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Cannot inject member " + this.member, ex);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalArgumentException("Attempt to inject setter method " + this.member + " resulted in an exception", ex);
                }
            }
        }

        public Class<?> getMemberType() {
            if (this.member instanceof Field) {
                return ((Field)this.member).getType();
            }
            if (this.member instanceof Method) {
                Method setter = (Method)this.member;
                if (setter.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Supposed setter " + this.member + " must have 1 argument, not " + setter.getParameterTypes().length);
                }
                return setter.getParameterTypes()[0];
            }
            throw new IllegalArgumentException("Unknown AccessibleObject type " + this.member.getClass() + "; Can only inject settermethods or fields");
        }

        protected Object resolve() {
            EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactoryByName(this.unitName);
            if (EntityManagerFactory.class.isAssignableFrom(this.getMemberType())) {
                if (!this.getMemberType().isInstance(emf)) {
                    throw new IllegalArgumentException("Cannot inject " + this.member + " with EntityManagerFactory [" + emf + "]: type mismatch");
                }
                return emf;
            }
            if (this.type == PersistenceContextType.TRANSACTION) {
                return SharedEntityManagerCreator.createSharedEntityManager(emf, this.getMemberType());
            }
            return ExtendedEntityManagerCreator.createContainerManagedEntityManager(emf);
        }
    }
}

