/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.object.SqlOperation;

public abstract class SqlQuery
extends SqlOperation {
    private int rowsExpected = 0;

    public SqlQuery() {
    }

    public SqlQuery(DataSource ds, String sql) {
        this.setDataSource(ds);
        this.setSql(sql);
    }

    public void setRowsExpected(int rowsExpected) {
        this.rowsExpected = rowsExpected;
    }

    public int getRowsExpected() {
        return this.rowsExpected;
    }

    public List execute(Object[] params, Map context) throws DataAccessException {
        this.validateParameters(params);
        RowMapper rowMapper = this.newRowMapper(params, context);
        return this.getJdbcTemplate().query(this.newPreparedStatementCreator(params), rowMapper);
    }

    public List execute(Object[] params) throws DataAccessException {
        return this.execute(params, null);
    }

    public List execute(Map context) throws DataAccessException {
        return this.execute((Object[])null, context);
    }

    public List execute() throws DataAccessException {
        return this.execute((Object[])null);
    }

    public List execute(int p1, Map context) throws DataAccessException {
        return this.execute(new Object[]{new Integer(p1)}, context);
    }

    public List execute(int p1) throws DataAccessException {
        return this.execute(p1, (Map)null);
    }

    public List execute(int p1, int p2, Map context) throws DataAccessException {
        return this.execute(new Object[]{new Integer(p1), new Integer(p2)}, context);
    }

    public List execute(int p1, int p2) throws DataAccessException {
        return this.execute(p1, p2, null);
    }

    public List execute(long p1, Map context) throws DataAccessException {
        return this.execute(new Object[]{new Long(p1)}, context);
    }

    public List execute(long p1) throws DataAccessException {
        return this.execute(p1, null);
    }

    public List execute(String p1, Map context) throws DataAccessException {
        return this.execute(new Object[]{p1}, context);
    }

    public List execute(String p1) throws DataAccessException {
        return this.execute(p1, null);
    }

    public List executeByNamedParam(Map paramMap, Map context) throws DataAccessException {
        this.validateNamedParameters(paramMap);
        Object[] parameters = NamedParameterUtils.buildValueArray(this.getSql(), paramMap);
        RowMapper rowMapper = this.newRowMapper(parameters, context);
        return this.getJdbcTemplate().query(this.newPreparedStatementCreator(parameters), rowMapper);
    }

    public List executeByNamedParam(Map paramMap) throws DataAccessException {
        return this.executeByNamedParam(paramMap, null);
    }

    public Object findObject(Object[] parameters, Map context) throws DataAccessException {
        List results = this.execute(parameters, context);
        return DataAccessUtils.uniqueResult(results);
    }

    public Object findObject(Object[] params) throws DataAccessException {
        return this.findObject(params, null);
    }

    public Object findObject(int p1, Map context) throws DataAccessException {
        return this.findObject(new Object[]{new Integer(p1)}, context);
    }

    public Object findObject(int p1) throws DataAccessException {
        return this.findObject(p1, (Map)null);
    }

    public Object findObject(int p1, int p2, Map context) throws DataAccessException {
        return this.findObject(new Object[]{new Integer(p1), new Integer(p2)}, context);
    }

    public Object findObject(int p1, int p2) throws DataAccessException {
        return this.findObject(p1, p2, null);
    }

    public Object findObject(long p1, Map context) throws DataAccessException {
        return this.findObject(new Object[]{new Long(p1)}, context);
    }

    public Object findObject(long p1) throws DataAccessException {
        return this.findObject(p1, null);
    }

    public Object findObject(String p1, Map context) throws DataAccessException {
        return this.findObject(new Object[]{p1}, context);
    }

    public Object findObject(String p1) throws DataAccessException {
        return this.findObject(p1, null);
    }

    public Object findObjectByNamedParam(Map paramMap, Map context) throws DataAccessException {
        List results = this.executeByNamedParam(paramMap, context);
        return DataAccessUtils.uniqueResult(results);
    }

    public Object findObjectByNamedParam(Map paramMap) throws DataAccessException {
        return this.findObjectByNamedParam(paramMap, null);
    }

    protected abstract RowMapper newRowMapper(Object[] var1, Map var2);
}

