/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class NamespaceHandlerUtils {
    public static final String AUTO_PROXY_CREATOR_BEAN_NAME = "org.springframework.aop.config.internalAutoProxyCreator";
    public static final String ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME = "org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator";
    private static final List APC_PRIORITY_LIST = new ArrayList();
    static /* synthetic */ Class class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator;

    public static void registerAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        NamespaceHandlerUtils.registryOrEscalateApcAsRequired(class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator = NamespaceHandlerUtils.class$("org.springframework.aop.framework.autoproxy.InvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator, registry);
    }

    public static void registerAspectJAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        NamespaceHandlerUtils.registryOrEscalateApcAsRequired(class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator = NamespaceHandlerUtils.class$("org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator, registry);
    }

    public static void registerAtAspectJAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        Class cls = NamespaceHandlerUtils.getAspectJAutoProxyCreatorClassIfPossible();
        if (cls == null) {
            throw new IllegalStateException("Unable to register AspectJ AutoProxyCreator. Cannot find class [org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator]. Are you running on Java 5.0+?");
        }
        NamespaceHandlerUtils.registryOrEscalateApcAsRequired(cls, registry);
    }

    private static void registryOrEscalateApcAsRequired(Class cls, BeanDefinitionRegistry registry) {
        Assert.notNull(cls, "'cls' cannot be null.");
        Assert.notNull(registry, "'registry' cannot be null.");
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            int requiredPriority;
            AbstractBeanDefinition abd = (AbstractBeanDefinition)registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            if (cls.equals(abd.getBeanClass())) {
                return;
            }
            int currentPriority = NamespaceHandlerUtils.findPriorityForClass(abd.getBeanClass().getName());
            if (currentPriority < (requiredPriority = NamespaceHandlerUtils.findPriorityForClass(cls.getName()))) {
                abd.setBeanClass(cls);
            }
        } else {
            registry.registerBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME, new RootBeanDefinition(cls));
        }
    }

    public static void forceAutoProxyCreatorToUseClassProxying(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            AbstractBeanDefinition definition = (AbstractBeanDefinition)registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            if (definition.getPropertyValues() == null) {
                definition.setPropertyValues(new MutablePropertyValues());
            }
            definition.getPropertyValues().addPropertyValue("proxyTargetClass", Boolean.TRUE);
        }
    }

    private static Class getAspectJAutoProxyCreatorClassIfPossible() {
        try {
            return ClassUtils.forName(ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private static Class getAtAspectJAutoProxyCreatorClassIfPossible() {
        try {
            return ClassUtils.forName(ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private static final int findPriorityForClass(String className) {
        Assert.notNull(className, "'className' cannot be null.");
        for (int i = 0; i < APC_PRIORITY_LIST.size(); ++i) {
            String s = (String)APC_PRIORITY_LIST.get(i);
            if (!className.equals(s)) continue;
            return i;
        }
        throw new IllegalArgumentException("Class name '" + className + "' is not a known APC class.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        APC_PRIORITY_LIST.add((class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator = NamespaceHandlerUtils.class$("org.springframework.aop.framework.autoproxy.InvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$InvocationContextExposingAdvisorAutoProxyCreator).getName());
        APC_PRIORITY_LIST.add((class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator = NamespaceHandlerUtils.class$("org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator).getName());
        APC_PRIORITY_LIST.add(ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
    }
}

