/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.web.servlet.config.MvcBeanDefinitionParserSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewResolversBeanDefinitionParser
extends MvcBeanDefinitionParserSupport
implements BeanDefinitionParser {
    private static final String INTERNAL_RESOURCE_VIEW_RESOLVER = "internal-resource-view-resolver";
    private static final String JSTL = "jstl";
    private static final String TILES = "tiles";
    private static final String TILES_JSTL = "tiles-jstl";
    private static final String BEAN_NAME_VIEW_RESOLVER = "bean-name-view-resolver";
    static /* synthetic */ Class class$org$springframework$core$Ordered;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$BeanNameViewResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$InternalResourceViewResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$JstlView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$tiles$TilesView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$tiles$TilesJstlView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$InternalResourceView;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Assert.notNull(element);
        Assert.notNull(parserContext);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        NodeList viewResolverChildren = element.getChildNodes();
        int viewResolverCount = 0;
        for (int i = 0; i < viewResolverChildren.getLength(); ++i) {
            Node viewResolverNode = viewResolverChildren.item(i);
            if (viewResolverNode.getNodeType() != 1) continue;
            Element viewResolverElement = (Element)viewResolverNode;
            RootBeanDefinition viewResolverDefinition = null;
            if (INTERNAL_RESOURCE_VIEW_RESOLVER.equals(viewResolverNode.getLocalName())) {
                viewResolverDefinition = this.parseInternalResourceViewResolver(viewResolverElement, registry);
            } else if (BEAN_NAME_VIEW_RESOLVER.equals(viewResolverNode.getLocalName())) {
                viewResolverDefinition = this.parseBeanNameViewResolver(viewResolverElement, registry);
            }
            if ((class$org$springframework$core$Ordered == null ? ViewResolversBeanDefinitionParser.class$("org.springframework.core.Ordered") : class$org$springframework$core$Ordered).isAssignableFrom(viewResolverDefinition.getBeanClass())) {
                viewResolverDefinition.getPropertyValues().addPropertyValue("order", new Integer(viewResolverCount++));
            }
            registry.registerBeanDefinition(BeanDefinitionReaderUtils.generateBeanName(viewResolverDefinition, registry, false), viewResolverDefinition);
        }
        return null;
    }

    private RootBeanDefinition parseBeanNameViewResolver(Element viewResolverElement, BeanDefinitionRegistry registry) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(class$org$springframework$web$servlet$view$BeanNameViewResolver == null ? (class$org$springframework$web$servlet$view$BeanNameViewResolver = ViewResolversBeanDefinitionParser.class$("org.springframework.web.servlet.view.BeanNameViewResolver")) : class$org$springframework$web$servlet$view$BeanNameViewResolver);
        return beanDefinition;
    }

    private RootBeanDefinition parseInternalResourceViewResolver(Element el, BeanDefinitionRegistry registry) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(class$org$springframework$web$servlet$view$InternalResourceViewResolver == null ? (class$org$springframework$web$servlet$view$InternalResourceViewResolver = ViewResolversBeanDefinitionParser.class$("org.springframework.web.servlet.view.InternalResourceViewResolver")) : class$org$springframework$web$servlet$view$InternalResourceViewResolver);
        this.setPropertyIfAvailable(el, "prefix", "prefix", beanDefinition);
        this.setPropertyIfAvailable(el, "suffix", "suffix", beanDefinition);
        this.setPropertyIfAvailable(el, "enable-caching", "cache", beanDefinition);
        this.setPropertyIfAvailable(el, "content-type", "contentType", beanDefinition);
        this.setPropertyIfAvailable(el, "redirect-context-relative", "redirectContextRelative", beanDefinition);
        this.setPropertyIfAvailable(el, "redirect-http10-compatible", "redirectHttp10Compatible", beanDefinition);
        this.setPropertyIfAvailable(el, "request-context-attribute", "requestContextAttribute", beanDefinition);
        String type = el.getAttribute("type");
        if (JSTL.equals(type)) {
            beanDefinition.getPropertyValues().addPropertyValue("viewClass", class$org$springframework$web$servlet$view$JstlView == null ? (class$org$springframework$web$servlet$view$JstlView = ViewResolversBeanDefinitionParser.class$("org.springframework.web.servlet.view.JstlView")) : class$org$springframework$web$servlet$view$JstlView);
        } else if (TILES.equals(type)) {
            beanDefinition.getPropertyValues().addPropertyValue("viewClass", class$org$springframework$web$servlet$view$tiles$TilesView == null ? (class$org$springframework$web$servlet$view$tiles$TilesView = ViewResolversBeanDefinitionParser.class$("org.springframework.web.servlet.view.tiles.TilesView")) : class$org$springframework$web$servlet$view$tiles$TilesView);
        } else if (TILES_JSTL.equals(type)) {
            beanDefinition.getPropertyValues().addPropertyValue("viewClass", class$org$springframework$web$servlet$view$tiles$TilesJstlView == null ? (class$org$springframework$web$servlet$view$tiles$TilesJstlView = ViewResolversBeanDefinitionParser.class$("org.springframework.web.servlet.view.tiles.TilesJstlView")) : class$org$springframework$web$servlet$view$tiles$TilesJstlView);
        } else {
            beanDefinition.getPropertyValues().addPropertyValue("viewClass", class$org$springframework$web$servlet$view$InternalResourceView == null ? (class$org$springframework$web$servlet$view$InternalResourceView = ViewResolversBeanDefinitionParser.class$("org.springframework.web.servlet.view.InternalResourceView")) : class$org$springframework$web$servlet$view$InternalResourceView);
        }
        return beanDefinition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

