/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.ReaderContext;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParserHelper;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.SystemPropertyUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlBeanDefinitionParser
implements XmlBeanDefinitionParser {
    public static final String BEANS_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    public static final String BEAN_NAME_DELIMITERS = ",; ";
    public static final String IMPORT_ELEMENT = "import";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    public static final String ALIAS_ELEMENT = "alias";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ATTRIBUTE = "alias";
    public static final String BEAN_ELEMENT = "bean";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private NamespaceHandlerResolver namespaceHandlerResolver;
    private ReaderContext readerContext;

    public void registerBeanDefinitions(Document doc, ReaderContext readerContext) {
        this.readerContext = readerContext;
        this.logger.debug((Object)"Loading bean definitions");
        Element root = doc.getDocumentElement();
        XmlBeanDefinitionParserHelper helper = this.createHelper(readerContext, root);
        this.preProcessXml(root);
        this.parseBeanDefinitions(root, helper);
        this.postProcessXml(root);
    }

    protected XmlBeanDefinitionParserHelper createHelper(ReaderContext readerContext, Element root) {
        XmlBeanDefinitionParserHelper helper = new XmlBeanDefinitionParserHelper(readerContext, this.createNamespaceHandlerResolver());
        helper.initDefaults(root);
        return helper;
    }

    protected final ReaderContext getReaderContext() {
        return this.readerContext;
    }

    protected void preProcessXml(Element root) {
    }

    protected NamespaceHandlerResolver createNamespaceHandlerResolver() {
        ClassLoader classLoader = this.getReaderContext().getReader().getBeanClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return new DefaultNamespaceHandlerResolver(classLoader);
    }

    protected void parseBeanDefinitions(Element root, XmlBeanDefinitionParserHelper helper) {
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            String namespaceUri = ele.getNamespaceURI();
            if (helper.isDefaultNamespace(namespaceUri)) {
                this.parseDefaultElement(ele, helper);
                continue;
            }
            helper.parseCustomElement(ele);
        }
    }

    private void parseDefaultElement(Element ele, XmlBeanDefinitionParserHelper helper) {
        BeanDefinitionHolder bdHolder;
        if (IMPORT_ELEMENT.equals(ele.getNodeName())) {
            this.importBeanDefinitionResource(ele);
        } else if ("alias".equals(ele.getNodeName())) {
            String name = ele.getAttribute(NAME_ATTRIBUTE);
            String alias = ele.getAttribute("alias");
            this.getReaderContext().getReader().getBeanFactory().registerAlias(name, alias);
        } else if (BEAN_ELEMENT.equals(ele.getNodeName()) && (bdHolder = helper.parseBeanDefinitionElement(ele, false)) != null) {
            bdHolder = helper.decorateBeanDefinitionIfRequired(ele, bdHolder);
            BeanDefinitionReaderUtils.registerBeanDefinition(bdHolder, this.getReaderContext().getReader().getBeanFactory());
            this.getReaderContext().fireComponentRegistered(new BeanComponentDefinition(bdHolder));
        }
    }

    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute(RESOURCE_ATTRIBUTE);
        if (ResourcePatternUtils.isUrl(location = SystemPropertyUtils.resolvePlaceholders(location))) {
            int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
            }
        } else {
            try {
                Resource relativeResource = this.getReaderContext().getResource().createRelative(location);
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(relativeResource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                }
            }
            catch (IOException ex) {
                this.getReaderContext().error("Invalid relative resource location [" + location + "] to import bean definitions from", ele, null, ex);
            }
        }
    }

    protected void postProcessXml(Element root) {
    }
}

