/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.scope;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.scope.RequestAttributes;

public class ServletRequestAttributes
implements RequestAttributes {
    private final HttpServletRequest request;

    public ServletRequestAttributes(HttpServletRequest request) {
        this.request = request;
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            return this.request.getAttribute(name);
        }
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return session.getAttribute(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            this.request.setAttribute(name, value);
        } else {
            HttpSession session = this.request.getSession(true);
            session.setAttribute(name, value);
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 0) {
            this.request.removeAttribute(name);
        } else {
            HttpSession session = this.request.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
            }
        }
    }
}

