/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.MultipartFile;

public class WebDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    private String fieldMarkerPrefix = "_";
    private boolean bindEmptyMultipartFiles = true;
    static /* synthetic */ Class class$java$lang$Boolean;

    public WebDataBinder(Object target) {
        super(target);
    }

    public WebDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.checkFieldMarkers(mpvs);
        super.doBind(mpvs);
    }

    protected void checkFieldMarkers(MutablePropertyValues mpvs) {
        if (this.getFieldMarkerPrefix() != null) {
            String fieldMarkerPrefix = this.getFieldMarkerPrefix();
            PropertyValue[] pvArray = mpvs.getPropertyValues();
            for (int i = 0; i < pvArray.length; ++i) {
                PropertyValue pv = pvArray[i];
                if (!pv.getName().startsWith(fieldMarkerPrefix)) continue;
                String field = pv.getName().substring(fieldMarkerPrefix.length());
                if (!this.getBeanWrapper().isWritableProperty(field) || mpvs.contains(field)) continue;
                Class fieldType = this.getBeanWrapper().getPropertyType(field);
                mpvs.addPropertyValue(field, this.getEmptyValue(field, fieldType));
            }
        }
    }

    protected Object getEmptyValue(String field, Class fieldType) {
        if (fieldType != null && Boolean.TYPE.equals(fieldType) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = WebDataBinder.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(fieldType)) {
            return Boolean.FALSE;
        }
        if (fieldType != null && fieldType.isArray()) {
            return Array.newInstance(fieldType.getComponentType(), 0);
        }
        return null;
    }

    protected void bindMultipartFiles(Map multipartFiles, MutablePropertyValues mpvs) {
        Iterator it = multipartFiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            MultipartFile value = (MultipartFile)entry.getValue();
            if (!this.isBindEmptyMultipartFiles() && value.isEmpty()) continue;
            mpvs.addPropertyValue(key, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

