/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Field;
import org.aopalliance.aop.Advice;
import org.aopalliance.aop.AspectException;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.support.ClassFilters;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.support.TypePatternClassFilter;

public class DeclareParentsAdvisor
implements IntroductionAdvisor {
    private final Class introducedInterface;
    private final ClassFilter typePatternClassFilter;
    private final Advice advice;

    public DeclareParentsAdvisor(Field introductionField, String typePattern, Class defaultImpl) {
        this.introducedInterface = introductionField.getType();
        TypePatternClassFilter typePatternFilter = new TypePatternClassFilter(typePattern);
        ClassFilter exclusion = new ClassFilter(){

            public boolean matches(Class clazz) {
                return !DeclareParentsAdvisor.this.introducedInterface.isAssignableFrom(clazz);
            }
        };
        this.typePatternClassFilter = ClassFilters.intersection(typePatternFilter, exclusion);
        try {
            Object newIntroductionInstanceToUse = defaultImpl.newInstance();
            this.advice = new DelegatingIntroductionInterceptor(newIntroductionInstanceToUse);
        }
        catch (IllegalArgumentException ex) {
            throw new AspectException("Cannot evaluate static introduction field " + introductionField, ex);
        }
        catch (IllegalAccessException ex) {
            throw new AspectException("Cannot evaluate static introduction field " + introductionField, ex);
        }
        catch (InstantiationException ex) {
            throw new AspectException("Cannot instantiate class determined from static introduction field " + introductionField, ex);
        }
    }

    public ClassFilter getClassFilter() {
        return this.typePatternClassFilter;
    }

    public void validateInterfaces() throws IllegalArgumentException {
    }

    public boolean isPerInstance() {
        return true;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public Class[] getInterfaces() {
        return new Class[]{this.introducedInterface};
    }
}

