/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeanUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.RedirectView;

public class UrlBasedViewResolver
extends AbstractCachingViewResolver {
    public static final String REDIRECT_URL_PREFIX = "redirect:";
    public static final String FORWARD_URL_PREFIX = "forward:";
    private Class viewClass;
    private String prefix = "";
    private String suffix = "";
    private String contentType;
    private boolean redirectContextRelative = true;
    private boolean redirectHttp10Compatible = true;
    private String requestContextAttribute;
    private final Map staticAttributes = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$servlet$view$AbstractUrlBasedView;

    public void setViewClass(Class viewClass) {
        if (viewClass == null || !this.requiredViewClass().isAssignableFrom(viewClass)) {
            throw new IllegalArgumentException("Given view class [" + (viewClass != null ? viewClass.getName() : null) + "] is not of type [" + this.requiredViewClass().getName() + "]");
        }
        this.viewClass = viewClass;
    }

    protected Class getViewClass() {
        return this.viewClass;
    }

    protected Class requiredViewClass() {
        return class$org$springframework$web$servlet$view$AbstractUrlBasedView == null ? (class$org$springframework$web$servlet$view$AbstractUrlBasedView = UrlBasedViewResolver.class$("org.springframework.web.servlet.view.AbstractUrlBasedView")) : class$org$springframework$web$servlet$view$AbstractUrlBasedView;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setRedirectContextRelative(boolean redirectContextRelative) {
        this.redirectContextRelative = redirectContextRelative;
    }

    public void setRedirectHttp10Compatible(boolean redirectHttp10Compatible) {
        this.redirectHttp10Compatible = redirectHttp10Compatible;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public void setAttributes(Properties props) {
        this.setAttributesMap(props);
    }

    public void setAttributesMap(Map attributes) {
        if (attributes != null) {
            this.staticAttributes.putAll(attributes);
        }
    }

    public Map getAttributesMap() {
        return this.staticAttributes;
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        if (this.viewClass == null) {
            throw new IllegalArgumentException("viewClass is required");
        }
    }

    protected String getCacheKey(String viewName, Locale locale) {
        return viewName;
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            String redirectUrl = viewName.substring(REDIRECT_URL_PREFIX.length());
            return new RedirectView(redirectUrl, this.redirectContextRelative, this.redirectHttp10Compatible);
        }
        if (viewName.startsWith(FORWARD_URL_PREFIX)) {
            String forwardUrl = viewName.substring(FORWARD_URL_PREFIX.length());
            return new InternalResourceView(forwardUrl);
        }
        return super.createView(viewName, locale);
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        AbstractUrlBasedView view = this.buildView(viewName);
        return (View)this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean(view, viewName);
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        AbstractUrlBasedView view = (AbstractUrlBasedView)BeanUtils.instantiateClass(this.viewClass);
        view.setUrl(this.prefix + viewName + this.suffix);
        if (this.contentType != null) {
            view.setContentType(this.contentType);
        }
        view.setRequestContextAttribute(this.requestContextAttribute);
        view.setAttributesMap(this.staticAttributes);
        return view;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

