/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.JdkVersion;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class JmxUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jmx$support$JmxUtils == null ? (class$org$springframework$jmx$support$JmxUtils = JmxUtils.class$("org.springframework.jmx.support.JmxUtils")) : class$org$springframework$jmx$support$JmxUtils));
    private static final String MANAGEMENT_FACTORY_CLASS = "java.lang.management.ManagementFactory";
    private static final String GET_PLATFORM_MBEAN_SERVER_METHOD = "getPlatformMBeanServer";
    private static final String MBEAN_SUFFIX = "MBean";
    public static final String IDENTITY_OBJECT_NAME_KEY = "identity";
    static /* synthetic */ Class class$org$springframework$jmx$support$JmxUtils;
    static /* synthetic */ Class class$javax$management$DynamicMBean;
    static /* synthetic */ Class class$java$lang$Object;

    public static MBeanServer locateMBeanServer() throws MBeanServerNotFoundException {
        return JmxUtils.locateMBeanServer(null);
    }

    public static MBeanServer locateMBeanServer(String agentId) throws MBeanServerNotFoundException {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(agentId);
        MBeanServer server = null;
        if (servers != null && servers.size() > 0) {
            if (servers.size() > 1 && logger.isWarnEnabled()) {
                logger.warn((Object)("Found more than one MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : "") + ". Returning first from list."));
            }
            server = (MBeanServer)servers.get(0);
        } else if (JdkVersion.getMajorJavaVersion() >= 2) {
            try {
                Class managementFactoryClass = ClassUtils.forName(MANAGEMENT_FACTORY_CLASS);
                Method getPlatformMBeanServer = managementFactoryClass.getMethod(GET_PLATFORM_MBEAN_SERVER_METHOD, null);
                server = (MBeanServer)getPlatformMBeanServer.invoke(null, null);
            }
            catch (InvocationTargetException ex) {
                throw new MBeanServerNotFoundException("ManagementFactory.getPlatformMBeanServer() threw exception", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new MBeanServerNotFoundException("Could not invoke ManagementFactory.getPlatformMBeanServer()", ex);
            }
        }
        if (server == null) {
            throw new MBeanServerNotFoundException("Unable to locate an MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : ""));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found MBeanServer: " + server));
        }
        return server;
    }

    public static Class[] parameterInfoToTypes(MBeanParameterInfo[] paramInfo) throws ClassNotFoundException {
        Class[] types = null;
        if (paramInfo != null && paramInfo.length > 0) {
            types = new Class[paramInfo.length];
            for (int x = 0; x < paramInfo.length; ++x) {
                types[x] = ClassUtils.forName(paramInfo[x].getType());
            }
        }
        return types;
    }

    public static String[] getMethodSignature(Method method) {
        Class<?>[] types = method.getParameterTypes();
        String[] signature = new String[types.length];
        for (int x = 0; x < types.length; ++x) {
            signature[x] = types[x].getName();
        }
        return signature;
    }

    public static String getAttributeName(PropertyDescriptor property, boolean useStrictCasing) {
        if (useStrictCasing) {
            return StringUtils.capitalize(property.getName());
        }
        return property.getName();
    }

    public static boolean isMBean(Class beanClass) {
        if (beanClass == null) {
            return false;
        }
        if ((class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = JmxUtils.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean).isAssignableFrom(beanClass)) {
            return true;
        }
        for (Class cls = beanClass; cls != null && cls != (class$java$lang$Object == null ? JmxUtils.class$("java.lang.Object") : class$java$lang$Object); cls = cls.getSuperclass()) {
            if (!JmxUtils.hasMBeanInterface(cls)) continue;
            return true;
        }
        return false;
    }

    public static Class getClassToExpose(Object managedBean) {
        if (AopUtils.isCglibProxy(managedBean)) {
            return managedBean.getClass().getSuperclass();
        }
        return managedBean.getClass();
    }

    public static Class getClassToExpose(Class beanClass) {
        if (AopUtils.isCglibProxyClass(beanClass)) {
            return beanClass.getSuperclass();
        }
        return beanClass;
    }

    private static boolean hasMBeanInterface(Class clazz) {
        Class<?>[] implementedInterfaces = clazz.getInterfaces();
        String mbeanInterfaceName = clazz.getName() + MBEAN_SUFFIX;
        for (int x = 0; x < implementedInterfaces.length; ++x) {
            Class<?> iface = implementedInterfaces[x];
            if (!iface.getName().equals(mbeanInterfaceName)) continue;
            return true;
        }
        return false;
    }

    public static ObjectName convertToObjectName(Object value) throws MalformedObjectNameException {
        Assert.notNull(value, "value must not be null");
        if (value instanceof ObjectName) {
            return (ObjectName)value;
        }
        if (value instanceof String) {
            return ObjectNameManager.getInstance((String)value);
        }
        throw new IllegalArgumentException("Unable to convert object of type [" + value.getClass() + "] to ObjectName");
    }

    public static ObjectName appendIdentityToObjectName(ObjectName objectName, Object managedResource) throws MalformedObjectNameException {
        Hashtable<String, String> keyProperties = objectName.getKeyPropertyList();
        keyProperties.put(IDENTITY_OBJECT_NAME_KEY, ObjectUtils.getIdentityHexString(managedResource));
        return ObjectNameManager.getInstance(objectName.getDomain(), keyProperties);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

