/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.ConfigurableBeanFactoryUtils;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.Lifecycle;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.ApplicationContextAwareProcessor;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext,
DisposableBean {
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    public static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "applicationEventMulticaster";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext parent;
    private final List beanFactoryPostProcessors = new ArrayList();
    private String displayName = this.getClass().getName() + ";hashCode=" + this.hashCode();
    private long startupTime;
    private boolean active = true;
    private Thread shutdownHook;
    private ResourcePatternResolver resourcePatternResolver;
    private MessageSource messageSource;
    private ApplicationEventMulticaster applicationEventMulticaster;
    static /* synthetic */ Class class$org$springframework$context$event$ContextClosedEvent;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$springframework$context$ResourceLoaderAware;
    static /* synthetic */ Class class$org$springframework$context$ApplicationEventPublisherAware;
    static /* synthetic */ Class class$org$springframework$context$MessageSourceAware;
    static /* synthetic */ Class class$org$springframework$context$ApplicationContextAware;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanFactoryPostProcessor;
    static /* synthetic */ Class class$org$springframework$core$Ordered;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$context$MessageSource;
    static /* synthetic */ Class class$org$springframework$context$event$ApplicationEventMulticaster;
    static /* synthetic */ Class class$org$springframework$context$ApplicationListener;
    static /* synthetic */ Class class$org$springframework$context$Lifecycle;

    public AbstractApplicationContext() {
        this((ApplicationContext)null);
    }

    public AbstractApplicationContext(ApplicationContext parent) {
        this.parent = parent;
        this.resourcePatternResolver = this.getResourcePatternResolver();
    }

    public ApplicationContext getParent() {
        return this.parent;
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return this.getBeanFactory();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getStartupDate() {
        return this.startupTime;
    }

    public void publishEvent(ApplicationEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing event in context [" + this.getDisplayName() + "]: " + event.toString()));
        }
        this.getApplicationEventMulticaster().multicastEvent(event);
        if (this.parent != null) {
            this.parent.publishEvent(event);
        }
    }

    private ApplicationEventMulticaster getApplicationEventMulticaster() throws IllegalStateException {
        if (this.applicationEventMulticaster == null) {
            throw new IllegalStateException("ApplicationEventMulticaster not initialized - call 'refresh' before multicasting events via the context: " + this);
        }
        return this.applicationEventMulticaster;
    }

    public void setParent(ApplicationContext parent) {
        this.parent = parent;
    }

    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.beanFactoryPostProcessors.add(beanFactoryPostProcessor);
    }

    public List getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    public void refresh() throws BeansException, IllegalStateException {
        this.startupTime = System.currentTimeMillis();
        this.refreshBeanFactory();
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        ConfigurableBeanFactoryUtils.registerResourceEditors((ConfigurableBeanFactory)beanFactory, this);
        beanFactory.registerCustomEditor(class$java$lang$Class == null ? (class$java$lang$Class = AbstractApplicationContext.class$("java.lang.Class")) : class$java$lang$Class, new ClassEditor(this.getClassLoader()));
        beanFactory.addBeanPostProcessor(new ApplicationContextAwareProcessor(this));
        beanFactory.ignoreDependencyInterface(class$org$springframework$context$ResourceLoaderAware == null ? (class$org$springframework$context$ResourceLoaderAware = AbstractApplicationContext.class$("org.springframework.context.ResourceLoaderAware")) : class$org$springframework$context$ResourceLoaderAware);
        beanFactory.ignoreDependencyInterface(class$org$springframework$context$ApplicationEventPublisherAware == null ? (class$org$springframework$context$ApplicationEventPublisherAware = AbstractApplicationContext.class$("org.springframework.context.ApplicationEventPublisherAware")) : class$org$springframework$context$ApplicationEventPublisherAware);
        beanFactory.ignoreDependencyInterface(class$org$springframework$context$MessageSourceAware == null ? (class$org$springframework$context$MessageSourceAware = AbstractApplicationContext.class$("org.springframework.context.MessageSourceAware")) : class$org$springframework$context$MessageSourceAware);
        beanFactory.ignoreDependencyInterface(class$org$springframework$context$ApplicationContextAware == null ? (class$org$springframework$context$ApplicationContextAware = AbstractApplicationContext.class$("org.springframework.context.ApplicationContextAware")) : class$org$springframework$context$ApplicationContextAware);
        this.postProcessBeanFactory(beanFactory);
        Iterator it = this.getBeanFactoryPostProcessors().iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor factoryProcessor = (BeanFactoryPostProcessor)it.next();
            factoryProcessor.postProcessBeanFactory(beanFactory);
        }
        if (this.logger.isInfoEnabled()) {
            if (this.getBeanDefinitionCount() == 0) {
                this.logger.info((Object)("No beans defined in application context [" + this.getDisplayName() + "]"));
            } else {
                this.logger.info((Object)(this.getBeanDefinitionCount() + " beans defined in application context [" + this.getDisplayName() + "]"));
            }
        }
        try {
            this.invokeBeanFactoryPostProcessors();
            this.registerBeanPostProcessors();
            this.initMessageSource();
            this.initApplicationEventMulticaster();
            this.onRefresh();
            this.registerListeners();
            beanFactory.preInstantiateSingletons();
            this.publishEvent(new ContextRefreshedEvent(this));
            this.active = true;
        }
        catch (BeansException ex) {
            beanFactory.destroySingletons();
            throw ex;
        }
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PathMatchingResourcePatternResolver(this);
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void invokeBeanFactoryPostProcessors() throws BeansException {
        String[] factoryProcessorNames = this.getBeanNamesForType(class$org$springframework$beans$factory$config$BeanFactoryPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanFactoryPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanFactoryPostProcessor")) : class$org$springframework$beans$factory$config$BeanFactoryPostProcessor, true, false);
        ArrayList<Object> orderedFactoryProcessors = new ArrayList<Object>();
        ArrayList<String> nonOrderedFactoryProcessorNames = new ArrayList<String>();
        for (int i = 0; i < factoryProcessorNames.length; ++i) {
            if ((class$org$springframework$core$Ordered == null ? AbstractApplicationContext.class$("org.springframework.core.Ordered") : class$org$springframework$core$Ordered).isAssignableFrom(this.getType(factoryProcessorNames[i]))) {
                orderedFactoryProcessors.add(this.getBean(factoryProcessorNames[i]));
                continue;
            }
            nonOrderedFactoryProcessorNames.add(factoryProcessorNames[i]);
        }
        Collections.sort(orderedFactoryProcessors, new OrderComparator());
        Iterator it = orderedFactoryProcessors.iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor factoryProcessor = (BeanFactoryPostProcessor)it.next();
            factoryProcessor.postProcessBeanFactory(this.getBeanFactory());
        }
        it = nonOrderedFactoryProcessorNames.iterator();
        while (it.hasNext()) {
            String factoryProcessorName = (String)it.next();
            ((BeanFactoryPostProcessor)this.getBean(factoryProcessorName)).postProcessBeanFactory(this.getBeanFactory());
        }
    }

    private void registerBeanPostProcessors() throws BeansException {
        int beanProcessorTargetCount = this.getBeanFactory().getBeanPostProcessorCount() + 1 + this.getBeanNamesForType(class$org$springframework$beans$factory$config$BeanPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanPostProcessor")) : class$org$springframework$beans$factory$config$BeanPostProcessor, true, false).length;
        this.getBeanFactory().addBeanPostProcessor(new BeanPostProcessorChecker(beanProcessorTargetCount));
        Map beanProcessorMap = this.getBeansOfType(class$org$springframework$beans$factory$config$BeanPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanPostProcessor")) : class$org$springframework$beans$factory$config$BeanPostProcessor, true, false);
        ArrayList beanProcessors = new ArrayList(beanProcessorMap.values());
        Collections.sort(beanProcessors, new OrderComparator());
        Iterator it = beanProcessors.iterator();
        while (it.hasNext()) {
            this.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)it.next());
        }
    }

    private void initMessageSource() throws BeansException {
        if (this.containsLocalBean(MESSAGE_SOURCE_BEAN_NAME)) {
            HierarchicalMessageSource hms;
            this.messageSource = (MessageSource)this.getBean(MESSAGE_SOURCE_BEAN_NAME, class$org$springframework$context$MessageSource == null ? (class$org$springframework$context$MessageSource = AbstractApplicationContext.class$("org.springframework.context.MessageSource")) : class$org$springframework$context$MessageSource);
            if (this.parent != null && this.messageSource instanceof HierarchicalMessageSource && (hms = (HierarchicalMessageSource)this.messageSource).getParentMessageSource() == null) {
                hms.setParentMessageSource(this.getInternalParentMessageSource());
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using MessageSource [" + this.messageSource + "]"));
            }
        } else {
            DelegatingMessageSource dms = new DelegatingMessageSource();
            dms.setParentMessageSource(this.getInternalParentMessageSource());
            this.messageSource = dms;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource + "]"));
            }
        }
    }

    private void initApplicationEventMulticaster() throws BeansException {
        if (this.containsLocalBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME)) {
            this.applicationEventMulticaster = (ApplicationEventMulticaster)this.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, class$org$springframework$context$event$ApplicationEventMulticaster == null ? (class$org$springframework$context$event$ApplicationEventMulticaster = AbstractApplicationContext.class$("org.springframework.context.event.ApplicationEventMulticaster")) : class$org$springframework$context$event$ApplicationEventMulticaster);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using ApplicationEventMulticaster [" + this.applicationEventMulticaster + "]"));
            }
        } else {
            this.applicationEventMulticaster = new SimpleApplicationEventMulticaster();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Unable to locate ApplicationEventMulticaster with name 'applicationEventMulticaster': using default [" + this.applicationEventMulticaster + "]"));
            }
        }
    }

    protected final boolean containsLocalBean(String beanName) {
        return this.containsBeanDefinition(beanName) || this.getBeanFactory().containsSingleton(beanName);
    }

    protected void onRefresh() throws BeansException {
    }

    private void registerListeners() throws BeansException {
        Collection listeners = this.getBeansOfType(class$org$springframework$context$ApplicationListener == null ? (class$org$springframework$context$ApplicationListener = AbstractApplicationContext.class$("org.springframework.context.ApplicationListener")) : class$org$springframework$context$ApplicationListener, true, false).values();
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            this.addListener((ApplicationListener)it.next());
        }
    }

    protected void addListener(ApplicationListener listener) {
        this.getApplicationEventMulticaster().addApplicationListener(listener);
    }

    public void registerShutdownHook() {
        this.shutdownHook = new Thread(){

            public void run() {
                AbstractApplicationContext.this.doClose();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void destroy() {
        this.close();
    }

    public void close() {
        this.doClose();
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        if (this.active) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Closing application context [" + this.getDisplayName() + "]"));
            }
            try {
                this.publishEvent(new ContextClosedEvent(this));
            }
            finally {
                ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
                if (beanFactory != null) {
                    beanFactory.destroySingletons();
                }
            }
            this.active = false;
        }
    }

    public Object getBean(String name) throws BeansException {
        return this.getBeanFactory().getBean(name);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBeanFactory().getBean(name, requiredType);
    }

    public boolean containsBean(String name) {
        return this.getBeanFactory().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isSingleton(name);
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getType(name);
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getAliases(name);
    }

    public boolean containsBeanDefinition(String name) {
        return this.getBeanFactory().containsBeanDefinition(name);
    }

    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanFactory().getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean includeFactoryBeans) {
        return this.getBeanFactory().getBeanNamesForType(type, includePrototypes, includeFactoryBeans);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type, includePrototypes, includeFactoryBeans);
    }

    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    protected BeanFactory getInternalParentBeanFactory() {
        return this.getParent() instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)this.getParent()).getBeanFactory() : this.getParent();
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(resolvable, locale);
    }

    private MessageSource getMessageSource() throws IllegalStateException {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized - call 'refresh' before accessing messages via the context: " + this);
        }
        return this.messageSource;
    }

    protected MessageSource getInternalParentMessageSource() {
        return this.getParent() instanceof AbstractApplicationContext ? ((AbstractApplicationContext)this.getParent()).messageSource : this.getParent();
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return this.resourcePatternResolver.getResources(locationPattern);
    }

    public void start() {
        Iterator it = this.getLifecycleBeans().iterator();
        while (it.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)it.next();
            if (lifecycle.isRunning()) continue;
            lifecycle.start();
        }
    }

    public void stop() {
        Iterator it = this.getLifecycleBeans().iterator();
        while (it.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)it.next();
            if (!lifecycle.isRunning()) continue;
            lifecycle.stop();
        }
    }

    public boolean isRunning() {
        Iterator it = this.getLifecycleBeans().iterator();
        while (it.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)it.next();
            if (lifecycle.isRunning()) continue;
            return false;
        }
        return true;
    }

    protected Collection getLifecycleBeans() {
        return this.getBeanFactory().getBeansOfType(class$org$springframework$context$Lifecycle == null ? (class$org$springframework$context$Lifecycle = AbstractApplicationContext.class$("org.springframework.context.Lifecycle")) : class$org$springframework$context$Lifecycle, false, false).values();
    }

    protected abstract void refreshBeanFactory() throws BeansException, IllegalStateException;

    public abstract ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException;

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(": ");
        sb.append("display name [").append(this.displayName).append("]; ");
        sb.append("startup date [").append(new Date(this.startupTime)).append("]; ");
        if (this.parent == null) {
            sb.append("root of context hierarchy");
        } else {
            sb.append("child of [").append(this.parent).append(']');
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        (class$org$springframework$context$event$ContextClosedEvent == null ? (class$org$springframework$context$event$ContextClosedEvent = AbstractApplicationContext.class$("org.springframework.context.event.ContextClosedEvent")) : class$org$springframework$context$event$ContextClosedEvent).getName();
    }

    private class BeanPostProcessorChecker
    implements BeanPostProcessor {
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(int beanPostProcessorTargetCount) {
            this.beanPostProcessorTargetCount = beanPostProcessorTargetCount;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (AbstractApplicationContext.this.getBeanFactory().getBeanPostProcessorCount() < this.beanPostProcessorTargetCount && AbstractApplicationContext.this.logger.isInfoEnabled()) {
                AbstractApplicationContext.this.logger.info((Object)("Bean '" + beanName + "' is not eligible for getting processed by all " + "BeanPostProcessors (for example: not eligible for auto-proxying)"));
            }
            return bean;
        }
    }
}

