/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.core.Constants;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    public static final int VALIDATION_AUTO = 0;
    public static final int VALIDATION_DTD = 1;
    public static final int VALIDATION_XSD = 2;
    private static final String SCHEMA_LANGUAGE_ATTRIBUTE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XSD_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    private static final int MAX_PEEK_LINES = 5;
    private static final Constants constants = new Constants(class$org$springframework$beans$factory$xml$XmlBeanDefinitionReader == null ? (class$org$springframework$beans$factory$xml$XmlBeanDefinitionReader = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.XmlBeanDefinitionReader")) : class$org$springframework$beans$factory$xml$XmlBeanDefinitionReader);
    private boolean namespaceAware = false;
    private boolean validating = true;
    private int validationMode = 0;
    private ErrorHandler errorHandler = new SimpleSaxErrorHandler(this.logger);
    private EntityResolver entityResolver = null;
    private Class parserClass = class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.DefaultXmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$XmlBeanDefinitionReader;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser;

    public XmlBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
        this.entityResolver = this.getResourceLoader() != null ? new ResourceEntityResolver(this.getResourceLoader()) : new DelegatingEntityResolver();
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setValidationMode(int validationMode) {
        this.validationMode = validationMode;
    }

    public void setValidationModeName(String validationModeName) {
        this.setValidationMode(constants.asNumber(validationModeName).intValue());
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setParserClass(Class parserClass) {
        if (this.parserClass == null || !(class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.XmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser).isAssignableFrom(parserClass)) {
            throw new IllegalArgumentException("parserClass must be an XmlBeanDefinitionParser");
        }
        this.parserClass = parserClass;
    }

    public int loadBeanDefinitions(Resource resource) throws BeansException {
        return this.loadBeanDefinitions(new EncodedResource(resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBeanDefinitions(EncodedResource encodedResource) throws BeansException {
        int n;
        if (encodedResource == null) {
            throw new BeanDefinitionStoreException("Resource cannot be null: expected an XML file");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loading XML bean definitions from " + encodedResource.getResource()));
        }
        InputStream inputStream = encodedResource.getResource().getInputStream();
        try {
            InputSource inputSource = new InputSource(inputStream);
            if (encodedResource.getEncoding() != null) {
                inputSource.setEncoding(encodedResource.getEncoding());
            }
            n = this.doLoadBeanDefinitions(inputSource, encodedResource.getResource());
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("IOException parsing XML document from " + encodedResource.getResource(), ex);
            }
        }
        inputStream.close();
        return n;
    }

    public int loadBeanDefinitions(InputSource inputSource) throws BeansException {
        return this.loadBeanDefinitions(inputSource, "resource loaded through SAX InputSource");
    }

    public int loadBeanDefinitions(InputSource inputSource, String resourceDescription) throws BeansException {
        return this.doLoadBeanDefinitions(inputSource, new DescriptiveResource(resourceDescription));
    }

    protected int doLoadBeanDefinitions(InputSource inputSource, Resource resource) throws BeansException {
        try {
            DocumentBuilderFactory factory = this.createDocumentBuilderFactory(resource);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using JAXP provider [" + factory + "]"));
            }
            DocumentBuilder builder = this.createDocumentBuilder(factory);
            Document doc = builder.parse(inputSource);
            return this.registerBeanDefinitions(doc, resource);
        }
        catch (ParserConfigurationException ex) {
            throw new BeanDefinitionStoreException("Parser configuration exception parsing XML from " + resource, ex);
        }
        catch (SAXParseException ex) {
            throw new BeanDefinitionStoreException("Line " + ex.getLineNumber() + " in XML document from " + resource + " is invalid", ex);
        }
        catch (SAXException ex) {
            throw new BeanDefinitionStoreException("XML document from " + resource + " is invalid", ex);
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("IOException parsing XML document from " + resource, ex);
        }
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory(Resource resource) throws ParserConfigurationException {
        int validationMode;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(this.validating);
        factory.setNamespaceAware(this.namespaceAware);
        if (this.validating && (validationMode = this.getValidationModeForResource(resource)) == 2) {
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute(SCHEMA_LANGUAGE_ATTRIBUTE, XSD_SCHEMA_LANGUAGE);
            }
            catch (IllegalArgumentException ex) {
                throw new FatalBeanException("Unable to validate using XSD: Your JAXP provider [" + factory + "] does not support XML Schema. " + "Are you running on Java 1.4 or below with Apache Crimson? " + "Upgrade to Apache Xerces (or Java 1.5) for full XSD support.");
            }
        }
        return factory;
    }

    private int getValidationModeForResource(Resource resource) {
        return this.validationMode != 0 ? this.validationMode : this.detectValidationMode(resource);
    }

    private int detectValidationMode(Resource resource) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
            boolean isDtdValidated = false;
            for (int x = 0; x < 5 && (line = reader.readLine()) != null; ++x) {
                if (line.indexOf("DOCTYPE") <= -1) continue;
                isDtdValidated = true;
                break;
            }
            int n = isDtdValidated ? 1 : 2;
            return n;
        }
        catch (IOException ex) {
            throw new FatalBeanException("Unable to determine validation mode for " + resource + ". Did you attempt to load directly from a SAX InputSource?", ex);
        }
        finally {
            block11: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        if (!this.logger.isWarnEnabled()) break block11;
                        this.logger.warn((Object)("Unable to close BufferedReader for " + resource), (Throwable)ex);
                    }
                }
            }
        }
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        if (this.errorHandler != null) {
            docBuilder.setErrorHandler(this.errorHandler);
        }
        if (this.entityResolver != null) {
            docBuilder.setEntityResolver(this.entityResolver);
        }
        return docBuilder;
    }

    public int registerBeanDefinitions(Document doc, Resource resource) throws BeansException {
        XmlBeanDefinitionParser parser = this.createXmlBeanDefinitionParser();
        return parser.registerBeanDefinitions(this, doc, resource);
    }

    protected XmlBeanDefinitionParser createXmlBeanDefinitionParser() {
        return (XmlBeanDefinitionParser)BeanUtils.instantiateClass(this.parserClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

