/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.autoproxy;

import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.beans.factory.BeanFactory;

public class PrototypeAspectInstanceFactory
implements MetadataAwareAspectInstanceFactory {
    private final BeanFactory beanFactory;
    private final String name;
    private final AspectMetadata am;
    private int instantiations;

    public PrototypeAspectInstanceFactory(BeanFactory beanFactory, String name) {
        this.beanFactory = beanFactory;
        if (beanFactory.isSingleton(name)) {
            throw new IllegalArgumentException("Cannot use PrototypeAspectInstanceFactory with bean named '" + name + "': not a prototype");
        }
        this.name = name;
        this.am = new AspectMetadata(beanFactory.getType(name));
    }

    public synchronized Object getAspectInstance() {
        ++this.instantiations;
        return this.beanFactory.getBean(this.name);
    }

    public AspectMetadata getAspectMetadata() {
        return this.am;
    }

    public int getInstantiationCount() {
        return this.instantiations;
    }

    public String toString() {
        return "PrototypeAspectInstanceFactory: bean name='" + this.name + "'; " + "instantiations=" + this.instantiations;
    }
}

