/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aspectj.weaver.tools.PointcutExpression;
import org.springframework.aop.aspectj.AspectInstanceFactory;
import org.springframework.aop.framework.AopConfigException;

abstract class AbstractAspectJAdvice {
    protected final Method aspectJAdviceMethod;
    private final PointcutExpression pointcutExpression;
    private final AspectInstanceFactory aif;

    public AbstractAspectJAdvice(Method aspectJAdviceMethod, PointcutExpression pointcutExpression, AspectInstanceFactory aif) {
        this.aspectJAdviceMethod = aspectJAdviceMethod;
        this.pointcutExpression = pointcutExpression;
        this.aif = aif;
    }

    public Method getAspectJAdviceMethod() {
        return this.aspectJAdviceMethod;
    }

    protected Object[] argBinding(Object[] availableArgs) {
        return availableArgs;
    }

    protected Object invokeAdviceMethod(Object[] argsInCall) throws Throwable {
        return this.invokeAdviceMethodWithGivenArgs(this.argBinding(argsInCall));
    }

    protected Object invokeAdviceMethodWithGivenArgs(Object[] args) throws Throwable {
        if (this.aspectJAdviceMethod.getParameterTypes().length == 0) {
            args = null;
        }
        try {
            return this.aspectJAdviceMethod.invoke(this.aif.getAspectInstance(), args);
        }
        catch (IllegalArgumentException ex) {
            throw new AopConfigException("Mismatch on arguments to advice method [" + this.aspectJAdviceMethod + "]; " + "pointcut expression = [" + this.pointcutExpression.getPointcutExpression() + "]", ex);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

