/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import org.springframework.util.Assert;

public abstract class NumberUtils {
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;

    public static Number convertNumberToTargetClass(Number number, Class targetClass) throws IllegalArgumentException {
        Assert.notNull(number, "Number must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number)) {
            return number;
        }
        if (targetClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(number.byteValue());
        }
        if (targetClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(number.shortValue());
        }
        if (targetClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(number.intValue());
        }
        if (targetClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(number.longValue());
        }
        if (targetClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(number.floatValue());
        }
        if (targetClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(number.doubleValue());
        }
        if (targetClass.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    public static Number parseNumber(String text, Class targetClass) {
        Assert.notNull(text, "Text must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        String trimmed = text.trim();
        if (targetClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.decode(trimmed);
        }
        if (targetClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.decode(trimmed);
        }
        if (targetClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.decode(trimmed);
        }
        if (targetClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.decode(trimmed);
        }
        if (targetClass.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return NumberUtils.decodeBigInteger(trimmed);
        }
        if (targetClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.valueOf(trimmed);
        }
        if (targetClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.valueOf(trimmed);
        }
        if (targetClass.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || targetClass.equals(class$java$lang$Number == null ? (class$java$lang$Number = NumberUtils.class$("java.lang.Number")) : class$java$lang$Number)) {
            return new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    public static Number parseNumber(String text, Class targetClass, NumberFormat numberFormat) {
        if (numberFormat != null) {
            Assert.notNull(text, "Text must not be null");
            Assert.notNull(targetClass, "Target class must not be null");
            try {
                Number number = numberFormat.parse(text.trim());
                return NumberUtils.convertNumberToTargetClass(number, targetClass);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        return NumberUtils.parseNumber(text, targetClass);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

