/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;

public abstract class ExpressionEvaluationUtils {
    private static final String JSP_20_CLASS_NAME = "javax.servlet.jsp.el.ExpressionEvaluator";
    private static final String JAKARTA_JSTL_CLASS_NAME = "org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$util$ExpressionEvaluationUtils == null ? (class$org$springframework$web$util$ExpressionEvaluationUtils = ExpressionEvaluationUtils.class$("org.springframework.web.util.ExpressionEvaluationUtils")) : class$org$springframework$web$util$ExpressionEvaluationUtils));
    private static ExpressionEvaluationHelper helper;
    static /* synthetic */ Class class$org$springframework$web$util$ExpressionEvaluationUtils;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static boolean isExpressionLanguage(String value) {
        return value != null && value.indexOf("${") != -1;
    }

    public static Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return helper.evaluate(attrName, attrValue, resultClass, pageContext);
        }
        if (attrValue != null && resultClass != null && !resultClass.isInstance(attrValue)) {
            throw new JspException("Attribute value \"" + attrValue + "\" is neither a JSP EL expression nor " + "assignable to result class [" + resultClass.getName() + "]");
        }
        return attrValue;
    }

    public static Object evaluate(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return helper.evaluate(attrName, attrValue, class$java$lang$Object == null ? (class$java$lang$Object = ExpressionEvaluationUtils.class$("java.lang.Object")) : class$java$lang$Object, pageContext);
        }
        return attrValue;
    }

    public static String evaluateString(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (String)helper.evaluate(attrName, attrValue, class$java$lang$String == null ? (class$java$lang$String = ExpressionEvaluationUtils.class$("java.lang.String")) : class$java$lang$String, pageContext);
        }
        return attrValue;
    }

    public static int evaluateInteger(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (Integer)helper.evaluate(attrName, attrValue, class$java$lang$Integer == null ? (class$java$lang$Integer = ExpressionEvaluationUtils.class$("java.lang.Integer")) : class$java$lang$Integer, pageContext);
        }
        return Integer.parseInt(attrValue);
    }

    public static boolean evaluateBoolean(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (Boolean)helper.evaluate(attrName, attrValue, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ExpressionEvaluationUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, pageContext);
        }
        return Boolean.valueOf(attrValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class.forName(JSP_20_CLASS_NAME);
            helper = new Jsp20ExpressionEvaluationHelper();
            logger.info((Object)"Using JSP 2.0 ExpressionEvaluator");
        }
        catch (ClassNotFoundException ex) {
            try {
                Class.forName(JAKARTA_JSTL_CLASS_NAME);
                helper = new JakartaExpressionEvaluationHelper();
                logger.info((Object)"Using Jakarta JSTL ExpressionEvaluatorManager");
            }
            catch (ClassNotFoundException ex2) {
                helper = new NoExpressionEvaluationHelper();
                logger.info((Object)"JSP expression evaluation not available");
            }
        }
    }

    private static class NoExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private NoExpressionEvaluationHelper() {
        }

        public Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
            throw new JspException("Neither JSP 2.0 nor Jakarta JSTL available - cannot parse JSP EL expression \"" + attrValue + "\"");
        }
    }

    private static class JakartaExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private JakartaExpressionEvaluationHelper() {
        }

        public Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
            return ExpressionEvaluatorManager.evaluate((String)attrName, (String)attrValue, (Class)resultClass, (PageContext)pageContext);
        }
    }

    private static class Jsp20ExpressionEvaluationHelper
    implements ExpressionEvaluationHelper {
        private Jsp20ExpressionEvaluationHelper() {
        }

        public Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
            try {
                return pageContext.getExpressionEvaluator().evaluate(attrValue, resultClass, pageContext.getVariableResolver(), null);
            }
            catch (ELException ex) {
                throw new JspException("Parsing of JSP EL expression \"" + attrValue + "\" failed", (Throwable)ex);
            }
        }
    }

    private static interface ExpressionEvaluationHelper {
        public Object evaluate(String var1, String var2, Class var3, PageContext var4) throws JspException;
    }
}

