/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.SessionHolder;
import org.springframework.orm.toplink.TopLinkAccessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TopLinkInterceptor
extends TopLinkAccessor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), true);
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            this.logger.debug((Object)"Found thread-bound Session for TopLink interceptor");
            existingTransaction = true;
        } else {
            this.logger.debug((Object)"Using new Session for TopLink interceptor");
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        }
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        catch (TopLinkException ex) {
            throw this.convertTopLinkAccessException(ex);
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound TopLink Session after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            }
        }
    }
}

