/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.jdo.JdoDialect;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class DefaultJdoDialect
implements JdoDialect {
    protected Log logger = LogFactory.getLog(this.getClass());
    private PersistenceManagerFactory persistenceManagerFactory;
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public DefaultJdoDialect() {
    }

    public DefaultJdoDialect(PersistenceManagerFactory pmf) {
        this.setPersistenceManagerFactory(pmf);
    }

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        if (this.jdbcExceptionTranslator == null) {
            this.jdbcExceptionTranslator = PersistenceManagerFactoryUtils.newJdbcExceptionTranslator(this.persistenceManagerFactory);
        }
        return this.jdbcExceptionTranslator;
    }

    public Object beginTransaction(Transaction transaction, TransactionDefinition definition) throws JDOException, SQLException, TransactionException {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Standard JDO does not support custom isolation levels - use a special JdoDialect for your JDO implementation");
        }
        transaction.begin();
        return null;
    }

    public void cleanupTransaction(Object transactionData) {
    }

    public ConnectionHandle getJdbcConnection(PersistenceManager pm, boolean readOnly) throws JDOException, SQLException {
        return new DataStoreConnectionHandle(pm);
    }

    public void releaseJdbcConnection(ConnectionHandle conHandle, PersistenceManager pm) throws JDOException, SQLException {
    }

    public Object detachCopy(PersistenceManager pm, Object entity) throws JDOException {
        return pm.detachCopy(entity);
    }

    public Collection detachCopyAll(PersistenceManager pm, Collection entities) throws JDOException {
        return pm.detachCopyAll(entities);
    }

    public Object attachCopy(PersistenceManager pm, Object detachedEntity) throws JDOException {
        return pm.attachCopy(detachedEntity, true);
    }

    public Collection attachCopyAll(PersistenceManager pm, Collection detachedEntities) throws JDOException {
        return pm.attachCopyAll(detachedEntities, true);
    }

    public void flush(PersistenceManager pm) throws JDOException {
        pm.flush();
    }

    public Query newNamedQuery(PersistenceManager pm, Class entityClass, String queryName) throws JDOException {
        return pm.newNamedQuery(entityClass, queryName);
    }

    public void applyQueryTimeout(Query query, int remainingTimeInSeconds) throws JDOException {
        this.logger.info((Object)"DefaultJdoDialect does not support query timeouts: ignoring remaining transaction time");
    }

    public DataAccessException translateException(JDOException ex) {
        if (ex.getCause() instanceof SQLException) {
            return this.getJdbcExceptionTranslator().translate("JDO operation: " + ex.getMessage(), this.extractSqlStringFromException(ex), (SQLException)ex.getCause());
        }
        return PersistenceManagerFactoryUtils.convertJdoAccessException(ex);
    }

    protected String extractSqlStringFromException(JDOException ex) {
        return null;
    }

    private static class DataStoreConnectionHandle
    implements ConnectionHandle {
        private final PersistenceManager persistenceManager;

        public DataStoreConnectionHandle(PersistenceManager persistenceManager) {
            this.persistenceManager = persistenceManager;
        }

        public Connection getConnection() {
            return (Connection)this.persistenceManager.getDataStoreConnection();
        }

        public void releaseConnection(Connection con) {
            JdbcUtils.closeConnection(con);
        }
    }
}

