/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class HibernateDaoSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private HibernateTemplate hibernateTemplate;

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.hibernateTemplate = this.createHibernateTemplate(sessionFactory);
    }

    protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
        return new HibernateTemplate(sessionFactory);
    }

    public final SessionFactory getSessionFactory() {
        return this.hibernateTemplate != null ? this.hibernateTemplate.getSessionFactory() : null;
    }

    public final void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public final HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.hibernateTemplate == null) {
            throw new IllegalArgumentException("sessionFactory or hibernateTemplate is required");
        }
        this.initDao();
    }

    protected void initDao() throws Exception {
    }

    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return this.getSession(this.hibernateTemplate.isAllowCreate());
    }

    protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return !allowCreate ? SessionFactoryUtils.getSession(this.getSessionFactory(), false) : SessionFactoryUtils.getSession(this.getSessionFactory(), this.hibernateTemplate.getEntityInterceptor(), this.hibernateTemplate.getJdbcExceptionTranslator());
    }

    protected final DataAccessException convertHibernateAccessException(HibernateException ex) {
        return this.hibernateTemplate.convertHibernateAccessException(ex);
    }

    protected final void closeSessionIfNecessary(Session session) {
        SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
    }
}

