/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.naming;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.StringUtils;

public class MetadataNamingStrategy
implements ObjectNamingStrategy {
    private JmxAttributeSource attributeSource;

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        this.attributeSource = attributeSource;
    }

    public ObjectName getObjectName(Object managedResource, String key) throws MalformedObjectNameException {
        ManagedResource mr = this.attributeSource.getManagedResource(managedResource.getClass());
        if (mr == null) {
            throw new MalformedObjectNameException("Your bean class [" + managedResource.getClass().getName() + "] must be marked with a valid ManagedResource attribute when using MetadataNamingStrategy");
        }
        String objectName = mr.getObjectName();
        if (!StringUtils.hasText(objectName)) {
            throw new MalformedObjectNameException("You must specify an ObjectName for class [" + managedResource.getClass().getName() + "]");
        }
        return ObjectNameManager.getInstance(objectName);
    }
}

