/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public abstract class JdbcDaoSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JdbcTemplate jdbcTemplate;

    public final void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = this.createJdbcTemplate(dataSource);
    }

    protected JdbcTemplate createJdbcTemplate(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    public final DataSource getDataSource() {
        return this.jdbcTemplate != null ? this.jdbcTemplate.getDataSource() : null;
    }

    public final void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.jdbcTemplate == null) {
            throw new IllegalArgumentException("dataSource or jdbcTemplate is required");
        }
        this.initDao();
    }

    protected void initDao() throws Exception {
    }

    protected final Connection getConnection() throws CannotGetJdbcConnectionException {
        return DataSourceUtils.getConnection(this.getDataSource());
    }

    protected final SQLExceptionTranslator getExceptionTranslator() {
        return this.jdbcTemplate.getExceptionTranslator();
    }

    protected final void closeConnectionIfNecessary(Connection con) {
        DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
    }
}

