/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate.HibernateAccessor;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class OpenSessionInViewInterceptor
extends HibernateAccessor
implements HandlerInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    private boolean singleSession = true;

    public OpenSessionInViewInterceptor() {
        this.setFlushMode(0);
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws DataAccessException {
        if (this.isSingleSession() && TransactionSynchronizationManager.hasResource(this.getSessionFactory()) || SessionFactoryUtils.isDeferredCloseActive(this.getSessionFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)new Integer(newCount));
        } else if (this.isSingleSession()) {
            this.logger.debug((Object)"Opening single Hibernate session in OpenSessionInViewInterceptor");
            Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
            if (this.getFlushMode() == 0) {
                session.setFlushMode(FlushMode.NEVER);
            }
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        } else {
            SessionFactoryUtils.initDeferredClose(this.getSessionFactory());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws DataAccessException {
        if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getSessionFactory());
            this.logger.debug((Object)"Flushing single Hibernate session in OpenSessionInViewInterceptor");
            try {
                this.flushIfNecessary(sessionHolder.getSession(), false);
            }
            catch (HibernateException ex) {
                throw this.convertHibernateAccessException(ex);
            }
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, (Object)new Integer(count - 1));
            } else {
                request.removeAttribute(participateAttributeName);
            }
        } else if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
            this.logger.debug((Object)"Closing single Hibernate session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.closeSessionIfNecessary(sessionHolder.getSession(), this.getSessionFactory());
        } else {
            SessionFactoryUtils.processDeferredClose(this.getSessionFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return this.getSessionFactory().toString() + PARTICIPATE_SUFFIX;
    }
}

