/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionObject;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DataSourceTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private DataSource dataSource;

    public DataSourceTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public DataSourceTransactionManager(DataSource dataSource) {
        this();
        this.dataSource = dataSource;
        this.afterPropertiesSet();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
    }

    protected Object doGetTransaction() {
        DataSourceTransactionObject txObject = new DataSourceTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.dataSource);
        txObject.setConnectionHolder(conHolder);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)transaction;
        return txObject.getConnectionHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)transaction;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Opening new connection for JDBC transaction");
        }
        Connection con = DataSourceUtils.getConnection(this.dataSource, false);
        txObject.setConnectionHolder(new ConnectionHolder(con));
        txObject.getConnectionHolder().setSynchronizedWithTransaction(true);
        try {
            Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction(con, definition);
            txObject.setPreviousIsolationLevel(previousIsolationLevel);
            if (con.getAutoCommit()) {
                txObject.setMustRestoreAutoCommit(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Switching JDBC connection [" + con + "] to manual commit"));
                }
                con.setAutoCommit(false);
            }
            if (definition.getTimeout() != -1) {
                txObject.getConnectionHolder().setTimeoutInSeconds(definition.getTimeout());
            }
            TransactionSynchronizationManager.bindResource(this.getDataSource(), txObject.getConnectionHolder());
        }
        catch (SQLException ex) {
            DataSourceUtils.closeConnectionIfNecessary(con, this.dataSource);
            throw new CannotCreateTransactionException("Could not configure JDBC connection for transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)transaction;
        txObject.setConnectionHolder(null);
        return TransactionSynchronizationManager.unbindResource(this.dataSource);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        ConnectionHolder conHolder = (ConnectionHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.dataSource, conHolder);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)status.getTransaction();
        Connection con = txObject.getConnectionHolder().getConnection();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing JDBC transaction on connection [" + con + "]"));
        }
        try {
            con.commit();
        }
        catch (SQLException ex) {
            throw new TransactionSystemException("Could not commit JDBC transaction", ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)status.getTransaction();
        Connection con = txObject.getConnectionHolder().getConnection();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back JDBC transaction on connection [" + con + "]"));
        }
        try {
            con.rollback();
        }
        catch (SQLException ex) {
            throw new TransactionSystemException("Could not roll back JDBC transaction", ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting JDBC transaction [" + txObject.getConnectionHolder().getConnection() + "] rollback-only"));
        }
        txObject.getConnectionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        DataSourceTransactionObject txObject = (DataSourceTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.dataSource);
        txObject.getConnectionHolder().clear();
        Connection con = txObject.getConnectionHolder().getConnection();
        try {
            if (txObject.getMustRestoreAutoCommit()) {
                con.setAutoCommit(true);
            }
            DataSourceUtils.resetConnectionAfterTransaction(con, txObject.getPreviousIsolationLevel());
        }
        catch (SQLException ex) {
            this.logger.info((Object)"Could not reset JDBC connection after transaction", (Throwable)ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing JDBC connection [" + con + "] after transaction"));
        }
        DataSourceUtils.closeConnectionIfNecessary(con, this.dataSource);
    }
}

