/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;

public abstract class BeanUtils {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$Class;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$Boolean;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Short;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class array$Ljava$lang$Long;
    static /* synthetic */ Class array$Ljava$lang$Float;
    static /* synthetic */ Class array$Ljava$lang$Double;

    public static Object instantiateClass(Class clazz) throws BeansException {
        try {
            return BeanUtils.instantiateClass(clazz.getDeclaredConstructor(null), null);
        }
        catch (NoSuchMethodException ex) {
            throw new FatalBeanException("Could not instantiate class [" + clazz.getName() + "]: no default constructor found", ex);
        }
    }

    public static Object instantiateClass(Constructor constructor, Object[] arguments) throws BeansException {
        try {
            if (!Modifier.isPublic(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(arguments);
        }
        catch (InstantiationException ex) {
            throw new FatalBeanException("Could not instantiate class [" + constructor.getDeclaringClass().getName() + "]: Is it an interface or an abstract class?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new FatalBeanException("Could not instantiate class [" + constructor.getDeclaringClass().getName() + "]: Has the class definition changed? Is the constructor accessible?", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new FatalBeanException("Could not instantiate class [" + constructor.getDeclaringClass().getName() + "]: illegal arguments for constructor", ex);
        }
        catch (InvocationTargetException ex) {
            throw new FatalBeanException("Could not instantiate class [" + constructor.getDeclaringClass().getName() + "]; constructor threw exception", ex.getTargetException());
        }
    }

    public static boolean isAssignable(Class type, Object value) {
        return value != null && BeanUtils.isAssignable(type, value.getClass()) || value == null && !type.isPrimitive();
    }

    public static boolean isAssignable(Class targetType, Class valueType) {
        return targetType.isAssignableFrom(valueType) || targetType.equals(Boolean.TYPE) && valueType.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean) || targetType.equals(Byte.TYPE) && valueType.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanUtils.class$("java.lang.Byte")) : class$java$lang$Byte) || targetType.equals(Character.TYPE) && valueType.equals(class$java$lang$Character == null ? (class$java$lang$Character = BeanUtils.class$("java.lang.Character")) : class$java$lang$Character) || targetType.equals(Short.TYPE) && valueType.equals(class$java$lang$Short == null ? (class$java$lang$Short = BeanUtils.class$("java.lang.Short")) : class$java$lang$Short) || targetType.equals(Integer.TYPE) && valueType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanUtils.class$("java.lang.Integer")) : class$java$lang$Integer) || targetType.equals(Long.TYPE) && valueType.equals(class$java$lang$Long == null ? (class$java$lang$Long = BeanUtils.class$("java.lang.Long")) : class$java$lang$Long) || targetType.equals(Float.TYPE) && valueType.equals(class$java$lang$Float == null ? (class$java$lang$Float = BeanUtils.class$("java.lang.Float")) : class$java$lang$Float) || targetType.equals(Double.TYPE) && valueType.equals(class$java$lang$Double == null ? (class$java$lang$Double = BeanUtils.class$("java.lang.Double")) : class$java$lang$Double);
    }

    public static boolean isSimpleProperty(Class clazz) {
        return clazz.isPrimitive() || BeanUtils.isPrimitiveArray(clazz) || BeanUtils.isPrimitiveWrapperArray(clazz) || clazz.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtils.class$("java.lang.String")) : class$java$lang$String) || clazz.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtils.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || clazz.equals(class$java$lang$Class == null ? (class$java$lang$Class = BeanUtils.class$("java.lang.Class")) : class$java$lang$Class) || clazz.equals(array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = BeanUtils.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        return (array$Z == null ? (array$Z = BeanUtils.class$("[Z")) : array$Z).equals(clazz) || (array$B == null ? (array$B = BeanUtils.class$("[B")) : array$B).equals(clazz) || (array$C == null ? (array$C = BeanUtils.class$("[C")) : array$C).equals(clazz) || (array$S == null ? (array$S = BeanUtils.class$("[S")) : array$S).equals(clazz) || (array$I == null ? (array$I = BeanUtils.class$("[I")) : array$I).equals(clazz) || (array$J == null ? (array$J = BeanUtils.class$("[J")) : array$J).equals(clazz) || (array$F == null ? (array$F = BeanUtils.class$("[F")) : array$F).equals(clazz) || (array$D == null ? (array$D = BeanUtils.class$("[D")) : array$D).equals(clazz);
    }

    public static boolean isPrimitiveWrapperArray(Class clazz) {
        return (array$Ljava$lang$Boolean == null ? (array$Ljava$lang$Boolean = BeanUtils.class$("[Ljava.lang.Boolean;")) : array$Ljava$lang$Boolean).equals(clazz) || (array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = BeanUtils.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte).equals(clazz) || (array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = BeanUtils.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character).equals(clazz) || (array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = BeanUtils.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short).equals(clazz) || (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = BeanUtils.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer).equals(clazz) || (array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = BeanUtils.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long).equals(clazz) || (array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = BeanUtils.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float).equals(clazz) || (array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = BeanUtils.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double).equals(clazz);
    }

    public static void copyProperties(Object source, Object target) throws IllegalArgumentException, BeansException {
        BeanUtils.copyProperties(source, target, null);
    }

    public static void copyProperties(Object source, Object target, String[] ignoreProperties) throws IllegalArgumentException, BeansException {
        if (source == null || target == null || !source.getClass().isInstance(target)) {
            throw new IllegalArgumentException("Target must be an instance of source");
        }
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        BeanWrapperImpl sourceBw = new BeanWrapperImpl(source);
        BeanWrapperImpl targetBw = new BeanWrapperImpl(target);
        MutablePropertyValues values = new MutablePropertyValues();
        for (int i = 0; i < sourceBw.getPropertyDescriptors().length; ++i) {
            PropertyDescriptor sourceDesc = sourceBw.getPropertyDescriptors()[i];
            String name = sourceDesc.getName();
            PropertyDescriptor targetDesc = targetBw.getPropertyDescriptor(name);
            if (targetDesc.getWriteMethod() == null || targetDesc.getReadMethod() == null || ignoreProperties != null && ignoreList.contains(name)) continue;
            values.addPropertyValue(new PropertyValue(name, sourceBw.getPropertyValue(name)));
        }
        targetBw.setPropertyValues(values);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

