/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.springframework.util.Log4jConfigurer;
import org.springframework.web.util.WebUtils;

public abstract class Log4jWebConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "log4jConfigLocation";
    public static final String REFRESH_INTERVAL_PARAM = "log4jRefreshInterval";
    public static final String FILE_URL_PREFIX = "file:";

    public static void initLogging(ServletContext servletContext) {
        block6: {
            WebUtils.setWebAppRootSystemProperty(servletContext);
            String location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
            if (location != null) {
                servletContext.log("Initializing Log4J from [" + location + "]");
                try {
                    String filePath = Log4jWebConfigurer.getFilePath(location, servletContext);
                    String intervalString = servletContext.getInitParameter(REFRESH_INTERVAL_PARAM);
                    if (intervalString != null) {
                        try {
                            long refreshInterval = Long.parseLong(intervalString);
                            Log4jConfigurer.initLogging(filePath, refreshInterval);
                            break block6;
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalArgumentException("Invalid 'log4jRefreshInterval' parameter: " + ex.getMessage());
                        }
                    }
                    Log4jConfigurer.initLogging(filePath);
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException("Invalid 'log4jConfigLocation' parameter: " + ex.getMessage());
                }
            }
        }
    }

    private static String getFilePath(String location, ServletContext servletContext) throws FileNotFoundException {
        String realPath;
        if (location.startsWith(FILE_URL_PREFIX)) {
            return location.substring(FILE_URL_PREFIX.length());
        }
        if (!location.startsWith("/")) {
            location = "/" + location;
        }
        if ((realPath = servletContext.getRealPath(location)) == null) {
            throw new FileNotFoundException("ServletContext resource [" + location + "] cannot be resolved to absolute file path - " + "web application archive not expanded?");
        }
        return realPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownLogging(ServletContext servletContext) {
        servletContext.log("Shutting down Log4J");
        try {
            Log4jConfigurer.shutdownLogging();
        }
        finally {
            WebUtils.removeWebAppRootSystemProperty(servletContext);
        }
    }
}

