/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.core.io.ResourceEditor;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResourceLoader;

public abstract class HttpServletBean
extends HttpServlet {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Set requiredProperties = new HashSet();
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init() throws ServletException {
        this.logger.info((Object)("Initializing servlet '" + this.getServletName() + "'"));
        try {
            ServletConfigPropertyValues pvs = new ServletConfigPropertyValues(this.getServletConfig(), this.requiredProperties);
            BeanWrapperImpl bw = new BeanWrapperImpl((Object)this);
            ServletContextResourceLoader resourceLoader = new ServletContextResourceLoader(this.getServletContext());
            bw.registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = HttpServletBean.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, new ResourceEditor(resourceLoader));
            this.initBeanWrapper(bw);
            bw.setPropertyValues(pvs);
        }
        catch (BeansException ex) {
            this.logger.error((Object)("Failed to set bean properties on servlet '" + this.getServletName() + "'"), (Throwable)ex);
            throw ex;
        }
        this.initServletBean();
        this.logger.info((Object)("Servlet '" + this.getServletName() + "' configured successfully"));
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    protected void initServletBean() throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ServletConfigPropertyValues
    extends MutablePropertyValues {
        private ServletConfigPropertyValues(ServletConfig config, Set requiredProperties) throws ServletException {
            HashSet missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet(requiredProperties) : null;
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new ServletException("Initialization from ServletConfig for servlet '" + config.getServletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, ", "));
            }
        }
    }
}

