/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerConfigException;
import org.quartz.impl.jdbcjobstore.JobStoreCMT;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class LocalDataSourceJobStore
extends JobStoreCMT {
    private DataSource dataSource;

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.setDataSource("dummy");
        this.setNonManagedTXDataSource("dummy");
        this.dataSource = SchedulerFactoryBean.getConfigTimeDataSource();
        if (this.dataSource == null) {
            throw new SchedulerConfigException("No local DataSource found for configuration - dataSource property must be set on SchedulerFactoryBean");
        }
        super.initialize(loadHelper, signaler);
    }

    protected Connection getConnection() {
        return DataSourceUtils.getConnection(this.dataSource);
    }

    protected Connection getNonManagedTXConnection() throws JobPersistenceException {
        try {
            Connection con = this.dataSource.getConnection();
            if (!this.isDontSetNonManagedTXConnectionAutoCommitFalse()) {
                con.setAutoCommit(false);
            }
            if (this.isTxIsolationLevelReadCommitted()) {
                con.setTransactionIsolation(1);
            }
            return con;
        }
        catch (SQLException ex) {
            throw new JobPersistenceException("Failed to prepare JDBC connection", (Exception)ex);
        }
    }

    protected void closeConnection(Connection con) {
        DataSourceUtils.closeConnectionIfNecessary(con, this.dataSource);
    }

    public void shutdown() {
    }
}

