/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.IOException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedAccessor;
import org.springframework.remoting.support.RemoteInvocationResult;

public class HttpInvokerClientInterceptor
extends RemoteInvocationBasedAccessor
implements MethodInterceptor,
HttpInvokerClientConfiguration {
    private HttpInvokerRequestExecutor httpInvokerRequestExecutor = new SimpleHttpInvokerRequestExecutor();

    public void setHttpInvokerRequestExecutor(HttpInvokerRequestExecutor httpInvokerRequestExecutor) {
        this.httpInvokerRequestExecutor = httpInvokerRequestExecutor;
    }

    public HttpInvokerRequestExecutor getHttpInvokerRequestExecutor() {
        return this.httpInvokerRequestExecutor;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (AopUtils.isToStringMethod(methodInvocation.getMethod())) {
            return "HTTP invoker proxy for service URL [" + this.getServiceUrl() + "]";
        }
        RemoteInvocation invocation = this.createRemoteInvocation(methodInvocation);
        RemoteInvocationResult result = null;
        try {
            result = this.executeRequest(invocation);
        }
        catch (IOException ex) {
            throw new RemoteAccessException("Cannot access HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RemoteAccessException("Cannot deserialize result from [" + this.getServiceUrl() + "]", ex);
        }
        return this.recreateRemoteInvocationResult(result);
    }

    protected RemoteInvocationResult executeRequest(RemoteInvocation invocation) throws IOException, ClassNotFoundException {
        return this.getHttpInvokerRequestExecutor().executeRequest(this, invocation);
    }
}

