/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.type.Type;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.hibernate.HibernateAccessor;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateOperations;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTemplate
extends HibernateAccessor
implements HibernateOperations {
    private boolean allowCreate = true;
    private boolean checkWriteOperations = true;
    private boolean cacheQueries = false;
    private String queryCacheRegion;

    public HibernateTemplate() {
    }

    public HibernateTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public HibernateTemplate(SessionFactory sessionFactory, boolean allowCreate) {
        this.setSessionFactory(sessionFactory);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setCheckWriteOperations(boolean checkWriteOperations) {
        this.checkWriteOperations = checkWriteOperations;
    }

    public boolean isCheckWriteOperations() {
        return this.checkWriteOperations;
    }

    public void setCacheQueries(boolean cacheQueries) {
        this.cacheQueries = cacheQueries;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public void setQueryCacheRegion(String queryCacheRegion) {
        this.queryCacheRegion = queryCacheRegion;
    }

    public String getQueryCacheRegion() {
        return this.queryCacheRegion;
    }

    public Object execute(HibernateCallback action) throws DataAccessException {
        Session session = !this.isAllowCreate() ? SessionFactoryUtils.getSession(this.getSessionFactory(), false) : SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
        boolean existingTransaction = TransactionSynchronizationManager.hasResource(this.getSessionFactory());
        if (!existingTransaction && this.getFlushMode() == 0) {
            session.setFlushMode(FlushMode.NEVER);
        }
        try {
            Object result = action.doInHibernate(session);
            this.flushIfNecessary(session, existingTransaction);
            Object object = result;
            return object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        catch (SQLException ex) {
            throw this.convertJdbcAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
        }
    }

    public List executeFind(HibernateCallback action) throws DataAccessException {
        return (List)this.execute(action);
    }

    public Object get(final Class entityClass, final Serializable id) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(entityClass, id);
            }
        });
    }

    public Object get(final Class entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(entityClass, id, lockMode);
            }
        });
    }

    public Object load(final Class entityClass, final Serializable id) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.load(entityClass, id);
            }
        });
    }

    public Object load(final Class entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.load(entityClass, id, lockMode);
            }
        });
    }

    public List loadAll(final Class entityClass) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateTemplate.this.createCriteria(session, entityClass);
                return criteria.list();
            }
        });
    }

    public void load(final Object entity, final Serializable id) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.load(entity, id);
                return null;
            }
        });
    }

    public void refresh(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.refresh(entity);
                return null;
            }
        });
    }

    public void refresh(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.refresh(entity, lockMode);
                return null;
            }
        });
    }

    public boolean contains(final Object entity) throws DataAccessException {
        Boolean result = (Boolean)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return new Boolean(session.contains(entity));
            }
        });
        return result;
    }

    public void evict(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.evict(entity);
                return null;
            }
        });
    }

    public void initialize(Object proxy) throws DataAccessException {
        try {
            Hibernate.initialize((Object)proxy);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    public void lock(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(entity, lockMode);
                return null;
            }
        });
    }

    public Serializable save(final Object entity) throws DataAccessException {
        return (Serializable)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.save(entity);
            }
        });
    }

    public void save(final Object entity, final Serializable id) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.save(entity, id);
                return null;
            }
        });
    }

    public void saveOrUpdate(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(entity);
                return null;
            }
        });
    }

    public Object saveOrUpdateCopy(final Object entity) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.saveOrUpdateCopy(entity);
            }
        });
    }

    public void update(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(entity);
                return null;
            }
        });
    }

    public void update(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(entity);
                session.lock(entity, lockMode);
                return null;
            }
        });
    }

    public void delete(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.delete(entity);
                return null;
            }
        });
    }

    public void delete(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.lock(entity, lockMode);
                session.delete(entity);
                return null;
            }
        });
    }

    public void deleteAll(final Collection entities) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    session.delete(it.next());
                }
                return null;
            }
        });
    }

    public void flush() throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.flush();
                return null;
            }
        });
    }

    public void clear() throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                session.clear();
                return null;
            }
        });
    }

    public List find(final String queryString) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                return queryObject.list();
            }
        });
    }

    public List find(String queryString, Object value) throws DataAccessException {
        return this.find(queryString, value, null);
    }

    public List find(final String queryString, final Object value, final Type type) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                if (type != null) {
                    queryObject.setParameter(0, value, type);
                } else {
                    queryObject.setParameter(0, value);
                }
                return queryObject.list();
            }
        });
    }

    public List find(String queryString, Object[] values) throws DataAccessException {
        return this.find(queryString, values, (Type[])null);
    }

    public List find(final String queryString, final Object[] values, final Type[] types) throws DataAccessException {
        if (types != null && values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                for (int i = 0; i < values.length; ++i) {
                    if (types != null) {
                        queryObject.setParameter(i, values[i], types[i]);
                        continue;
                    }
                    queryObject.setParameter(i, values[i]);
                }
                return queryObject.list();
            }
        });
    }

    public List findByNamedParam(String queryString, String paramName, Object value) throws DataAccessException {
        return this.findByNamedParam(queryString, paramName, value, null);
    }

    public List findByNamedParam(final String queryString, final String paramName, final Object value, final Type type) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramName, value, type);
                return queryObject.list();
            }
        });
    }

    public List findByNamedParam(String queryString, String[] paramNames, Object[] values) throws DataAccessException {
        return this.findByNamedParam(queryString, paramNames, values, null);
    }

    public List findByNamedParam(final String queryString, final String[] paramNames, final Object[] values, final Type[] types) throws DataAccessException {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        if (types != null && paramNames.length != types.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of types array");
        }
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                for (int i = 0; i < values.length; ++i) {
                    HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i], types != null ? types[i] : null);
                }
                return queryObject.list();
            }
        });
    }

    public List findByValueBean(final String queryString, final Object valueBean) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(String queryName, Object value) throws DataAccessException {
        return this.findByNamedQuery(queryName, value, null);
    }

    public List findByNamedQuery(final String queryName, final Object value, final Type type) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                if (type != null) {
                    queryObject.setParameter(0, value, type);
                } else {
                    queryObject.setParameter(0, value);
                }
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(String queryName, Object[] values) throws DataAccessException {
        return this.findByNamedQuery(queryName, values, (Type[])null);
    }

    public List findByNamedQuery(final String queryName, final Object[] values, final Type[] types) throws DataAccessException {
        if (types != null && values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                for (int i = 0; i < values.length; ++i) {
                    if (types != null) {
                        queryObject.setParameter(i, values[i], types[i]);
                        continue;
                    }
                    queryObject.setParameter(i, values[i]);
                }
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(String queryName, String paramName, Object value) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, paramName, value);
    }

    public List findByNamedQuery(String queryName, String paramName, Object value, Type type) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, paramName, value, type);
    }

    public List findByNamedQuery(String queryName, String[] paramNames, Object[] values) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, paramNames, values);
    }

    public List findByNamedQuery(String queryName, String[] paramNames, Object[] values, Type[] types) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, paramNames, values, types);
    }

    public List findByNamedQueryAndNamedParam(String queryName, String paramName, Object value) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, paramName, value, null);
    }

    public List findByNamedQueryAndNamedParam(final String queryName, final String paramName, final Object value, final Type type) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramName, value, type);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQueryAndNamedParam(String queryName, String[] paramNames, Object[] values) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, paramNames, values, null);
    }

    public List findByNamedQueryAndNamedParam(final String queryName, final String[] paramNames, final Object[] values, final Type[] types) throws DataAccessException {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        if (types != null && paramNames.length != types.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of types array");
        }
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                for (int i = 0; i < values.length; ++i) {
                    HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i], types != null ? types[i] : null);
                }
                return queryObject.list();
            }
        });
    }

    public List findByNamedQueryAndValueBean(final String queryName, final Object valueBean) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        });
    }

    public Iterator iterate(final String queryString) throws DataAccessException {
        return (Iterator)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                return queryObject.iterate();
            }
        });
    }

    public Iterator iterate(String queryString, Object value) throws DataAccessException {
        return this.iterate(queryString, value, null);
    }

    public Iterator iterate(final String queryString, final Object value, final Type type) throws DataAccessException {
        return (Iterator)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                if (type != null) {
                    queryObject.setParameter(0, value, type);
                } else {
                    queryObject.setParameter(0, value);
                }
                return queryObject.iterate();
            }
        });
    }

    public Iterator iterate(String queryString, Object[] values) throws DataAccessException {
        return this.iterate(queryString, values, (Type[])null);
    }

    public Iterator iterate(final String queryString, final Object[] values, final Type[] types) throws DataAccessException {
        if (values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return (Iterator)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                for (int i = 0; i < values.length; ++i) {
                    if (types != null) {
                        queryObject.setParameter(i, values[i], types[i]);
                        continue;
                    }
                    queryObject.setParameter(i, values[i]);
                }
                return queryObject.iterate();
            }
        });
    }

    public void closeIterator(Iterator it) throws DataAccessException {
        try {
            Hibernate.close((Iterator)it);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    public int delete(final String queryString) throws DataAccessException {
        Integer deleteCount = (Integer)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return new Integer(session.delete(queryString));
            }
        });
        return deleteCount;
    }

    public int delete(final String queryString, final Object value, final Type type) throws DataAccessException {
        Integer deleteCount = (Integer)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return new Integer(session.delete(queryString, value, type));
            }
        });
        return deleteCount;
    }

    public int delete(final String queryString, final Object[] values, final Type[] types) throws DataAccessException {
        Integer deleteCount = (Integer)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return new Integer(session.delete(queryString, values, types));
            }
        });
        return deleteCount;
    }

    protected void checkWriteOperationAllowed(Session session) throws InvalidDataAccessApiUsageException {
        if (this.isCheckWriteOperations() && this.getFlushMode() != 2 && FlushMode.NEVER.equals(session.getFlushMode())) {
            throw new InvalidDataAccessApiUsageException("Write operations are not allowed in read-only mode (FlushMode.NEVER) - turn your Session into FlushMode.AUTO respectively remove 'readOnly' marker from transaction definition");
        }
    }

    public Query createQuery(Session session, String queryString) throws HibernateException {
        Query queryObject = session.createQuery(queryString);
        this.prepareQuery(queryObject);
        return queryObject;
    }

    public Query getNamedQuery(Session session, String queryName) throws HibernateException {
        Query queryObject = session.getNamedQuery(queryName);
        this.prepareQuery(queryObject);
        return queryObject;
    }

    protected void prepareQuery(Query queryObject) {
        if (this.isCacheQueries()) {
            queryObject.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                queryObject.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        SessionFactoryUtils.applyTransactionTimeout(queryObject, this.getSessionFactory());
    }

    public Criteria createCriteria(Session session, Class entityClass) throws HibernateException {
        Criteria criteria = session.createCriteria(entityClass);
        if (this.isCacheQueries()) {
            criteria.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                criteria.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        SessionFactoryUtils.applyTransactionTimeout(criteria, this.getSessionFactory());
        return criteria;
    }

    protected void applyNamedParameterToQuery(Query queryObject, String paramName, Object value, Type type) throws HibernateException {
        if (value instanceof Collection) {
            if (type != null) {
                queryObject.setParameterList(paramName, (Collection)value, type);
            } else {
                queryObject.setParameterList(paramName, (Collection)value);
            }
        } else if (value instanceof Object[]) {
            if (type != null) {
                queryObject.setParameterList(paramName, (Object[])value, type);
            } else {
                queryObject.setParameterList(paramName, (Object[])value);
            }
        } else if (type != null) {
            queryObject.setParameter(paramName, value, type);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }
}

