/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class GenericApplicationContext
extends AbstractApplicationContext
implements BeanDefinitionRegistry {
    private final DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory(this.getInternalParentBeanFactory());
    private boolean refreshed = false;

    public GenericApplicationContext() {
        this((ApplicationContext)null);
    }

    public GenericApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    protected void refreshBeanFactory() throws IllegalStateException {
        if (this.refreshed) {
            throw new IllegalStateException("Multiple refreshs not supported - just call 'refresh' once");
        }
        this.refreshed = true;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public DefaultListableBeanFactory getDefaultListableBeanFactory() {
        return this.beanFactory;
    }

    public BeanDefinition getBeanDefinition(String name) throws BeansException {
        return this.beanFactory.getBeanDefinition(name);
    }

    public void registerBeanDefinition(String name, BeanDefinition beanDefinition) throws BeansException {
        this.beanFactory.registerBeanDefinition(name, beanDefinition);
    }

    public void registerAlias(String name, String alias) throws BeansException {
        this.beanFactory.registerAlias(name, alias);
    }
}

