/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.ApplicationContextAwareProcessor;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext {
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    public static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "applicationEventMulticaster";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext parent;
    private final List beanFactoryPostProcessors = new ArrayList();
    private String displayName = this.getClass().getName() + ";hashCode=" + this.hashCode();
    private long startupTime;
    private MessageSource messageSource;
    private ApplicationEventMulticaster applicationEventMulticaster;
    static /* synthetic */ Class class$org$springframework$context$event$ContextClosedEvent;
    static /* synthetic */ Class class$org$springframework$core$io$Resource;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class array$Lorg$springframework$core$io$Resource;
    static /* synthetic */ Class class$org$springframework$core$io$ResourceLoader;
    static /* synthetic */ Class class$org$springframework$context$ApplicationContext;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanFactoryPostProcessor;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$context$ApplicationListener;

    public AbstractApplicationContext() {
    }

    public AbstractApplicationContext(ApplicationContext parent) {
        this.parent = parent;
    }

    public ApplicationContext getParent() {
        return this.parent;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getStartupDate() {
        return this.startupTime;
    }

    public void publishEvent(ApplicationEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing event in context [" + this.getDisplayName() + "]: " + event.toString()));
        }
        this.getApplicationEventMulticaster().multicastEvent(event);
        if (this.parent != null) {
            this.parent.publishEvent(event);
        }
    }

    private ApplicationEventMulticaster getApplicationEventMulticaster() throws IllegalStateException {
        if (this.applicationEventMulticaster == null) {
            throw new IllegalStateException("ApplicationEventMulticaster not initialized - call 'refresh' before multicasting events via the context: " + this);
        }
        return this.applicationEventMulticaster;
    }

    public void setParent(ApplicationContext parent) {
        this.parent = parent;
    }

    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.beanFactoryPostProcessors.add(beanFactoryPostProcessor);
    }

    public List getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    public void refresh() throws BeansException, IllegalStateException {
        this.startupTime = System.currentTimeMillis();
        this.refreshBeanFactory();
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        beanFactory.registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = AbstractApplicationContext.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, new ResourceEditor(this));
        beanFactory.registerCustomEditor(class$java$net$URL == null ? (class$java$net$URL = AbstractApplicationContext.class$("java.net.URL")) : class$java$net$URL, new URLEditor(new ResourceEditor(this)));
        beanFactory.registerCustomEditor(class$java$io$InputStream == null ? (class$java$io$InputStream = AbstractApplicationContext.class$("java.io.InputStream")) : class$java$io$InputStream, new InputStreamEditor(new ResourceEditor(this)));
        beanFactory.registerCustomEditor(array$Lorg$springframework$core$io$Resource == null ? (array$Lorg$springframework$core$io$Resource = AbstractApplicationContext.class$("[Lorg.springframework.core.io.Resource;")) : array$Lorg$springframework$core$io$Resource, new ResourceArrayPropertyEditor(this.getResourcePatternResolver()));
        beanFactory.addBeanPostProcessor(new ApplicationContextAwareProcessor(this));
        beanFactory.ignoreDependencyType(class$org$springframework$core$io$ResourceLoader == null ? (class$org$springframework$core$io$ResourceLoader = AbstractApplicationContext.class$("org.springframework.core.io.ResourceLoader")) : class$org$springframework$core$io$ResourceLoader);
        beanFactory.ignoreDependencyType(class$org$springframework$context$ApplicationContext == null ? (class$org$springframework$context$ApplicationContext = AbstractApplicationContext.class$("org.springframework.context.ApplicationContext")) : class$org$springframework$context$ApplicationContext);
        this.postProcessBeanFactory(beanFactory);
        Iterator it = this.getBeanFactoryPostProcessors().iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor factoryProcessor = (BeanFactoryPostProcessor)it.next();
            factoryProcessor.postProcessBeanFactory(beanFactory);
        }
        if (this.logger.isInfoEnabled()) {
            if (this.getBeanDefinitionCount() == 0) {
                this.logger.info((Object)("No beans defined in application context [" + this.getDisplayName() + "]"));
            } else {
                this.logger.info((Object)(this.getBeanDefinitionCount() + " beans defined in application context [" + this.getDisplayName() + "]"));
            }
        }
        this.invokeBeanFactoryPostProcessors();
        this.registerBeanPostProcessors();
        this.initMessageSource();
        this.initApplicationEventMulticaster();
        this.onRefresh();
        this.refreshListeners();
        beanFactory.preInstantiateSingletons();
        this.publishEvent(new ContextRefreshedEvent(this));
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PathMatchingResourcePatternResolver(this);
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void invokeBeanFactoryPostProcessors() throws BeansException {
        Map factoryProcessorMap = this.getBeansOfType(class$org$springframework$beans$factory$config$BeanFactoryPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanFactoryPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanFactoryPostProcessor")) : class$org$springframework$beans$factory$config$BeanFactoryPostProcessor, true, false);
        ArrayList factoryProcessors = new ArrayList(factoryProcessorMap.values());
        Collections.sort(factoryProcessors, new OrderComparator());
        Iterator it = factoryProcessors.iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor factoryProcessor = (BeanFactoryPostProcessor)it.next();
            factoryProcessor.postProcessBeanFactory(this.getBeanFactory());
        }
    }

    private void registerBeanPostProcessors() throws BeansException {
        Map beanProcessorMap = this.getBeansOfType(class$org$springframework$beans$factory$config$BeanPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanPostProcessor")) : class$org$springframework$beans$factory$config$BeanPostProcessor, true, false);
        ArrayList beanProcessors = new ArrayList(beanProcessorMap.values());
        Collections.sort(beanProcessors, new OrderComparator());
        Iterator it = beanProcessors.iterator();
        while (it.hasNext()) {
            this.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)it.next());
        }
    }

    private void initMessageSource() throws BeansException {
        block4: {
            try {
                MessageSource parentMessageSource;
                this.messageSource = (MessageSource)this.getBean(MESSAGE_SOURCE_BEAN_NAME);
                if (this.parent != null && this.messageSource instanceof HierarchicalMessageSource && this.messageSource != (parentMessageSource = this.getInternalParentMessageSource())) {
                    ((HierarchicalMessageSource)this.messageSource).setParentMessageSource(parentMessageSource);
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using MessageSource [" + this.messageSource + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.messageSource = new StaticMessageSource();
                if (!this.logger.isInfoEnabled()) break block4;
                this.logger.info((Object)("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource + "]"));
            }
        }
    }

    private void initApplicationEventMulticaster() throws BeansException {
        block3: {
            try {
                this.applicationEventMulticaster = (ApplicationEventMulticaster)this.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using ApplicationEventMulticaster [" + this.applicationEventMulticaster + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.applicationEventMulticaster = new SimpleApplicationEventMulticaster();
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info((Object)("Unable to locate ApplicationEventMulticaster with name 'applicationEventMulticaster': using default [" + this.applicationEventMulticaster + "]"));
            }
        }
    }

    protected void onRefresh() throws BeansException {
    }

    private void refreshListeners() throws BeansException {
        this.logger.info((Object)"Refreshing listeners");
        Collection listeners = this.getBeansOfType(class$org$springframework$context$ApplicationListener == null ? (class$org$springframework$context$ApplicationListener = AbstractApplicationContext.class$("org.springframework.context.ApplicationListener")) : class$org$springframework$context$ApplicationListener, false, false).values();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found " + listeners.size() + " listeners in bean factory"));
        }
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ApplicationListener listener = (ApplicationListener)it.next();
            this.addListener(listener);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Application listener [" + listener + "] added"));
        }
    }

    protected void addListener(ApplicationListener listener) {
        this.getApplicationEventMulticaster().addApplicationListener(listener);
    }

    public void close() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Closing application context [" + this.getDisplayName() + "]"));
        }
        this.publishEvent(new ContextClosedEvent(this));
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            beanFactory.destroySingletons();
        }
    }

    public Object getBean(String name) throws BeansException {
        return this.getBeanFactory().getBean(name);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBeanFactory().getBean(name, requiredType);
    }

    public boolean containsBean(String name) {
        return this.getBeanFactory().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isSingleton(name);
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getType(name);
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getAliases(name);
    }

    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    public String[] getBeanDefinitionNames(Class type) {
        return this.getBeanFactory().getBeanDefinitionNames(type);
    }

    public boolean containsBeanDefinition(String name) {
        return this.getBeanFactory().containsBeanDefinition(name);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type, includePrototypes, includeFactoryBeans);
    }

    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    protected BeanFactory getInternalParentBeanFactory() {
        return this.getParent() instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)this.getParent()).getBeanFactory() : this.getParent();
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(resolvable, locale);
    }

    private MessageSource getMessageSource() throws IllegalStateException {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized - call 'refresh' before accessing messages via the context: " + this);
        }
        return this.messageSource;
    }

    protected MessageSource getInternalParentMessageSource() {
        return this.getParent() instanceof AbstractApplicationContext ? ((AbstractApplicationContext)this.getParent()).messageSource : this.getParent();
    }

    protected abstract void refreshBeanFactory() throws BeansException, IllegalStateException;

    public abstract ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException;

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(": ");
        sb.append("display name [").append(this.displayName).append("]; ");
        sb.append("startup date [").append(new Date(this.startupTime)).append("]; ");
        if (this.parent == null) {
            sb.append("root of context hierarchy");
        } else {
            sb.append("child of [").append(this.parent).append(']');
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        (class$org$springframework$context$event$ContextClosedEvent == null ? (class$org$springframework$context$event$ContextClosedEvent = AbstractApplicationContext.class$("org.springframework.context.event.ContextClosedEvent")) : class$org$springframework$context$event$ContextClosedEvent).getName();
    }
}

