/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugInterceptor
implements MethodInterceptor,
Serializable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int count;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ++this.count;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Before invocation (count=" + this.count + "): " + invocation));
        }
        try {
            Object rval = invocation.proceed();
            if (this.logger.isInfoEnabled()) {
                this.logger.debug((Object)("Invocation successfully returned (count=" + this.count + "): " + invocation));
            }
            return rval;
        }
        catch (Throwable ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invocation threw exception (count=" + this.count + "): " + invocation), ex);
            }
            throw ex;
        }
    }

    public int getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0;
    }
}

