/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisedSupportListener;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.UnknownAdviceTypeException;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.OrderComparator;

public class ProxyFactoryBean
extends AdvisedSupport
implements FactoryBean,
BeanFactoryAware,
AdvisedSupportListener {
    public static final String GLOBAL_SUFFIX = "*";
    private String[] interceptorNames;
    private boolean singleton = true;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private BeanFactory beanFactory;
    private String targetName;
    private Object singletonInstance;
    static /* synthetic */ Class class$org$springframework$aop$Advisor;
    static /* synthetic */ Class class$org$aopalliance$aop$Advice;
    static /* synthetic */ Class class$org$aopalliance$intercept$Interceptor;

    public void setProxyInterfaces(String[] interfaceNames) throws ClassNotFoundException {
        Class[] interfaces = AopUtils.toInterfaceArray(interfaceNames);
        this.setInterfaces(interfaces);
    }

    public void setInterceptorNames(String[] interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.createAdvisorChain();
        if (this.singleton) {
            this.targetSource = this.freshTargetSource();
            this.getSingletonInstance();
            this.addListener(this);
        }
    }

    public Object getObject() throws BeansException {
        return this.singleton ? this.getSingletonInstance() : this.newPrototypeInstance();
    }

    public Class getObjectType() {
        return this.singletonInstance != null ? this.singletonInstance.getClass() : this.getTargetSource().getTargetClass();
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    private Object getSingletonInstance() {
        if (this.singletonInstance == null) {
            this.singletonInstance = this.createAopProxy().getProxy();
        }
        return this.singletonInstance;
    }

    private synchronized Object newPrototypeInstance() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating copy of prototype ProxyFactoryBean config: " + this));
        }
        AdvisedSupport copy = new AdvisedSupport();
        copy.copyConfigurationFrom(this, this.freshTargetSource(), this.freshAdvisorChain());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Copy has config: " + copy));
        }
        return copy.createAopProxy().getProxy();
    }

    private void createAdvisorChain() throws AopConfigException, BeansException {
        if (this.interceptorNames == null || this.interceptorNames.length == 0) {
            return;
        }
        if (this.interceptorNames[this.interceptorNames.length - 1].endsWith(GLOBAL_SUFFIX) && this.targetSource == EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("Target required after globals");
        }
        for (int i = 0; i < this.interceptorNames.length; ++i) {
            String name = this.interceptorNames[i];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Configuring advisor or advice '" + name + "'"));
            }
            if (name.endsWith(GLOBAL_SUFFIX)) {
                if (!(this.beanFactory instanceof ListableBeanFactory)) {
                    throw new AopConfigException("Can only use global advisors or interceptors with a ListableBeanFactory");
                }
                this.addGlobalAdvisor((ListableBeanFactory)this.beanFactory, name.substring(0, name.length() - GLOBAL_SUFFIX.length()));
                continue;
            }
            if (i == this.interceptorNames.length - 1 && this.targetSource == EMPTY_TARGET_SOURCE && !this.isNamedBeanAnAdvisorOrAdvice(this.interceptorNames[i])) {
                this.targetName = this.interceptorNames[i];
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Bean with name '" + this.interceptorNames[i] + "' concluding interceptor chain is not an advisor class: " + "treating it as a target or TargetSource"));
                continue;
            }
            Object advice = null;
            advice = this.isSingleton() || this.beanFactory.isSingleton(this.interceptorNames[i]) ? this.beanFactory.getBean(this.interceptorNames[i]) : new PrototypePlaceholderAdvisor(this.interceptorNames[i]);
            this.addAdvisorOnChainCreation(advice, this.interceptorNames[i]);
        }
    }

    private boolean isNamedBeanAnAdvisorOrAdvice(String beanName) {
        Class namedBeanClass = this.beanFactory.getType(beanName);
        if (namedBeanClass != null) {
            return (class$org$springframework$aop$Advisor == null ? (class$org$springframework$aop$Advisor = ProxyFactoryBean.class$("org.springframework.aop.Advisor")) : class$org$springframework$aop$Advisor).isAssignableFrom(namedBeanClass) || (class$org$aopalliance$aop$Advice == null ? (class$org$aopalliance$aop$Advice = ProxyFactoryBean.class$("org.aopalliance.aop.Advice")) : class$org$aopalliance$aop$Advice).isAssignableFrom(namedBeanClass);
        }
        return true;
    }

    private List freshAdvisorChain() {
        Advisor[] advisors = this.getAdvisors();
        ArrayList<Advisor> freshAdvisors = new ArrayList<Advisor>(advisors.length);
        for (int i = 0; i < advisors.length; ++i) {
            if (advisors[i] instanceof PrototypePlaceholderAdvisor) {
                PrototypePlaceholderAdvisor pa = (PrototypePlaceholderAdvisor)advisors[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Refreshing bean named '" + pa.getBeanName() + "'"));
                }
                Object bean = this.beanFactory.getBean(pa.getBeanName());
                Advisor refreshedAdvisor = this.namedBeanToAdvisor(bean);
                freshAdvisors.add(refreshedAdvisor);
                continue;
            }
            freshAdvisors.add(advisors[i]);
        }
        return freshAdvisors;
    }

    private void addGlobalAdvisor(ListableBeanFactory beanFactory, String prefix) {
        Object bean;
        String name;
        int i;
        String[] globalAdvisorNames = BeanFactoryUtils.beanNamesIncludingAncestors(beanFactory, class$org$springframework$aop$Advisor == null ? (class$org$springframework$aop$Advisor = ProxyFactoryBean.class$("org.springframework.aop.Advisor")) : class$org$springframework$aop$Advisor);
        String[] globalInterceptorNames = BeanFactoryUtils.beanNamesIncludingAncestors(beanFactory, class$org$aopalliance$intercept$Interceptor == null ? (class$org$aopalliance$intercept$Interceptor = ProxyFactoryBean.class$("org.aopalliance.intercept.Interceptor")) : class$org$aopalliance$intercept$Interceptor);
        ArrayList<Object> beans = new ArrayList<Object>(globalAdvisorNames.length + globalInterceptorNames.length);
        HashMap<Object, String> names = new HashMap<Object, String>();
        for (i = 0; i < globalAdvisorNames.length; ++i) {
            name = globalAdvisorNames[i];
            bean = beanFactory.getBean(name);
            beans.add(bean);
            names.put(bean, name);
        }
        for (i = 0; i < globalInterceptorNames.length; ++i) {
            name = globalInterceptorNames[i];
            bean = beanFactory.getBean(name);
            beans.add(bean);
            names.put(bean, name);
        }
        Collections.sort(beans, new OrderComparator());
        Iterator it = beans.iterator();
        while (it.hasNext()) {
            Object bean2 = it.next();
            String name2 = (String)names.get(bean2);
            if (!name2.startsWith(prefix)) continue;
            this.addAdvisorOnChainCreation(bean2, name2);
        }
    }

    private void addAdvisorOnChainCreation(Object next, String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding advisor or TargetSource [" + next + "] with name [" + name + "]"));
        }
        Advisor advisor = this.namedBeanToAdvisor(next);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding advisor with name [" + name + "]"));
        }
        this.addAdvisor(advisor);
    }

    private TargetSource freshTargetSource() {
        Object target;
        if (this.targetName == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Not refreshing target: bean name not specified in interceptorNames");
            }
            return this.targetSource;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshing target with name '" + this.targetName + "'"));
        }
        return (target = this.beanFactory.getBean(this.targetName)) instanceof TargetSource ? (TargetSource)target : new SingletonTargetSource(target);
    }

    private Advisor namedBeanToAdvisor(Object next) {
        try {
            return this.advisorAdapterRegistry.wrap(next);
        }
        catch (UnknownAdviceTypeException ex) {
            throw new AopConfigException("Unknown advisor type " + next.getClass() + "; Can only include Advisor or Advice type beans in interceptorNames chain except for last entry," + "which may also be target or TargetSource", ex);
        }
    }

    public void activated(AdvisedSupport advisedSupport) {
    }

    public void adviceChanged(AdvisedSupport advisedSupport) {
        if (this.singleton) {
            this.logger.info((Object)"Advice has changed; recaching singleton instance");
            this.singletonInstance = null;
            this.getSingletonInstance();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PrototypePlaceholderAdvisor
    implements Advisor {
        private final String beanName;
        private final String message;

        public PrototypePlaceholderAdvisor(String beanName) {
            this.beanName = beanName;
            this.message = "Placeholder for prototype Advisor/Advice with bean name ='" + beanName + "'";
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Advice getAdvice() {
            throw new UnsupportedOperationException("Cannot invoke methods: " + this.message);
        }

        public boolean isPerInstance() {
            throw new UnsupportedOperationException("Cannot invoke methods: " + this.message);
        }

        public String toString() {
            return this.message;
        }
    }
}

