/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class RemoteExporter
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object service;
    private Class serviceInterface;

    public void setService(Object service) {
        this.service = service;
    }

    protected Object getService() {
        return this.service;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (!serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    protected Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.service == null) {
            throw new IllegalArgumentException("service is required");
        }
        if (this.serviceInterface == null) {
            throw new IllegalArgumentException("serviceInterface is required");
        }
        if (!this.serviceInterface.isInstance(this.service)) {
            throw new IllegalArgumentException("serviceInterface [" + this.serviceInterface.getName() + "] needs to be implemented by service [" + this.service + "]");
        }
    }

    protected Object getProxyForService() {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addInterface(this.serviceInterface);
        proxyFactory.setTarget(this.service);
        return proxyFactory.getProxy();
    }
}

