/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.support.AopUtils;

public class DelegatingIntroductionInterceptor
implements IntroductionInterceptor,
Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private Set publishedInterfaces = new HashSet();
    private Object delegate;
    static /* synthetic */ Class class$org$springframework$aop$IntroductionInterceptor;

    public DelegatingIntroductionInterceptor(Object delegate) {
        this.init(delegate);
    }

    protected DelegatingIntroductionInterceptor() {
        this.init(this);
    }

    private void init(Object delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate cannot be null in DelegatingIntroductionInterceptor");
        }
        this.delegate = delegate;
        this.publishedInterfaces.addAll(AopUtils.getAllInterfacesAsList(delegate));
        this.suppressInterface(class$org$springframework$aop$IntroductionInterceptor == null ? (class$org$springframework$aop$IntroductionInterceptor = DelegatingIntroductionInterceptor.class$("org.springframework.aop.IntroductionInterceptor")) : class$org$springframework$aop$IntroductionInterceptor);
    }

    public void suppressInterface(Class intf) {
        this.publishedInterfaces.remove(intf);
    }

    public Class[] getIntroducedInterfaces() {
        return this.publishedInterfaces.toArray(new Class[this.publishedInterfaces.size()]);
    }

    public boolean implementsInterface(Class intf) {
        Iterator it = this.publishedInterfaces.iterator();
        while (it.hasNext()) {
            Class pubIntf = (Class)it.next();
            if (!intf.isAssignableFrom(pubIntf)) continue;
            return true;
        }
        return false;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking self on invocation [" + mi + "]; breaking interceptor chain"));
            }
            return mi.getMethod().invoke(this.delegate, mi.getArguments());
        }
        return mi.proceed();
    }

    protected final boolean isMethodOnIntroducedInterface(MethodInvocation mi) {
        return this.implementsInterface(mi.getMethod().getDeclaringClass());
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        try {
            ois.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            throw new AspectException("Failed to deserialize Spring DelegatingIntroductionInterceptor:Check that Spring AOP libraries and implementation class for the introduction are available on the client side");
        }
        this.logger = LogFactory.getLog(this.getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

