/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class WebUtils {
    public static final String TEMP_DIR_CONTEXT_ATTRIBUTE = "javax.servlet.context.tempdir";
    public static final String WEB_APP_ROOT_KEY_PARAM = "webAppRootKey";
    public static final String DEFAULT_WEB_APP_ROOT_KEY = "webapp.root";
    public static final String[] SUBMIT_IMAGE_SUFFIXES = new String[]{".x", ".y"};

    public static void setWebAppRootSystemProperty(ServletContext servletContext) throws IllegalStateException {
        String param = servletContext.getInitParameter(WEB_APP_ROOT_KEY_PARAM);
        String key = param != null ? param : DEFAULT_WEB_APP_ROOT_KEY;
        String oldValue = System.getProperty(key);
        String root = servletContext.getRealPath("/");
        if (root == null) {
            throw new IllegalStateException("Cannot set web app root system property when WAR file is not expanded");
        }
        if (oldValue != null && !oldValue.equals(root)) {
            throw new IllegalStateException("Web app root system property already set to different value: '" + key + "' = [" + oldValue + "] - Choose unique webAppRootKey values in your web.xml files!");
        }
        System.setProperty(key, root);
        servletContext.log("Set web app root system property: " + key + " = " + root);
    }

    public static File getTempDir(ServletContext servletContext) {
        return (File)servletContext.getAttribute(TEMP_DIR_CONTEXT_ATTRIBUTE);
    }

    public static Object getSessionAttribute(HttpServletRequest request, String name) {
        HttpSession session = request.getSession(false);
        return session != null ? session.getAttribute(name) : null;
    }

    public static void setSessionAttribute(HttpServletRequest request, String name, Object value) {
        if (value != null) {
            request.getSession().setAttribute(name, value);
        } else {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
            }
        }
    }

    public static Object getOrCreateSessionAttribute(HttpServletRequest request, String name, Class clazz) throws ServletException {
        Object sessionObject = WebUtils.getSessionAttribute(request, name);
        if (sessionObject == null) {
            try {
                sessionObject = clazz.newInstance();
            }
            catch (InstantiationException ex) {
                throw new ServletException("Could not instantiate class [" + clazz.getName() + "] for session attribute '" + name + "'", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new ServletException("Could not access default constructor of class [" + clazz.getName() + "] for session attribute '" + name + "'", (Throwable)ex);
            }
            request.getSession(true).setAttribute(name, sessionObject);
        }
        return sessionObject;
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!name.equals(cookies[i].getName())) continue;
                return cookies[i];
            }
        }
        return null;
    }

    public static Map getParametersStartingWith(ServletRequest request, String base) {
        Enumeration enumeration = request.getParameterNames();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (base == null) {
            base = "";
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            String paramName = (String)enumeration.nextElement();
            if (base != null && !"".equals(base) && !paramName.startsWith(base)) continue;
            String unprefixed = paramName.substring(base.length());
            String[] values = request.getParameterValues(paramName);
            if (values == null) continue;
            if (values.length > 1) {
                params.put(unprefixed, values);
                continue;
            }
            params.put(unprefixed, values[0]);
        }
        return params;
    }

    public static boolean hasSubmitParameter(ServletRequest request, String name) {
        if (request.getParameter(name) != null) {
            return true;
        }
        for (int i = 0; i < SUBMIT_IMAGE_SUFFIXES.length; ++i) {
            String suffix = SUBMIT_IMAGE_SUFFIXES[i];
            if (request.getParameter(name + suffix) == null) continue;
            return true;
        }
        return false;
    }
}

