/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;
import org.springframework.orm.hibernate.LocalDataSourceConnectionProvider;
import org.springframework.orm.hibernate.LocalTransactionManagerLookup;

public class LocalSessionFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static ThreadLocal configTimeLobHandlerHolder = new ThreadLocal();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String configLocation;
    private String[] mappingResources;
    private String[] mappingResourceJars;
    private Properties hibernateProperties;
    private DataSource dataSource;
    private TransactionManager jtaTransactionManager;
    private LobHandler lobHandler;
    private Interceptor entityInterceptor;
    private boolean schemaUpdate = false;
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$org$springframework$orm$hibernate$LocalDataSourceConnectionProvider;
    static /* synthetic */ Class class$org$springframework$orm$hibernate$LocalTransactionManagerLookup;
    static /* synthetic */ Class class$net$sf$hibernate$SessionFactory;

    public static LobHandler getConfigTimeLobHandler() {
        LobHandler result = (LobHandler)configTimeLobHandlerHolder.get();
        if (result == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        return result;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setMappingResources(String[] mappingResources) {
        this.mappingResources = mappingResources;
    }

    public void setMappingResourceJars(String[] mappingResourceJars) {
        this.mappingResourceJars = mappingResourceJars;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setJtaTransactionManager(TransactionManager jtaTransactionManager) {
        this.jtaTransactionManager = jtaTransactionManager;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public void setSchemaUpdate(boolean schemaUpdate) {
        this.schemaUpdate = schemaUpdate;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, HibernateException {
        String resourcePath;
        Configuration config = this.newConfiguration();
        if (this.lobHandler != null) {
            configTimeLobHandlerHolder.set(this.lobHandler);
        }
        if (this.configLocation != null) {
            String resourceLocation = this.configLocation;
            if (!resourceLocation.startsWith("/")) {
                resourceLocation = "/" + resourceLocation;
            }
            config.configure(resourceLocation);
        }
        if (this.mappingResources != null) {
            for (int i = 0; i < this.mappingResources.length; ++i) {
                resourcePath = this.mappingResources[i];
                if (resourcePath.startsWith("/")) {
                    resourcePath = resourcePath.substring(1);
                }
                config.addResource(resourcePath, Thread.currentThread().getContextClassLoader());
            }
        }
        if (this.mappingResourceJars != null) {
            for (int i = 0; i < this.mappingResourceJars.length; ++i) {
                resourcePath = this.mappingResourceJars[i];
                if (resourcePath.startsWith("/")) {
                    resourcePath = resourcePath.substring(1);
                }
                config.addJar(resourcePath);
            }
        }
        if (this.hibernateProperties != null) {
            config.addProperties(this.hibernateProperties);
        }
        if (this.dataSource != null) {
            config.setProperty("hibernate.connection.provider_class", (class$org$springframework$orm$hibernate$LocalDataSourceConnectionProvider == null ? (class$org$springframework$orm$hibernate$LocalDataSourceConnectionProvider = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate.LocalDataSourceConnectionProvider")) : class$org$springframework$orm$hibernate$LocalDataSourceConnectionProvider).getName());
            LocalDataSourceConnectionProvider.configTimeDataSourceHolder.set(this.dataSource);
        }
        if (this.jtaTransactionManager != null) {
            config.setProperty("hibernate.transaction.manager_lookup_class", (class$org$springframework$orm$hibernate$LocalTransactionManagerLookup == null ? (class$org$springframework$orm$hibernate$LocalTransactionManagerLookup = LocalSessionFactoryBean.class$("org.springframework.orm.hibernate.LocalTransactionManagerLookup")) : class$org$springframework$orm$hibernate$LocalTransactionManagerLookup).getName());
            LocalTransactionManagerLookup.configTimeTransactionManagerHolder.set(this.jtaTransactionManager);
        }
        if (this.entityInterceptor != null) {
            config.setInterceptor(this.entityInterceptor);
        }
        this.postProcessConfiguration(config);
        this.logger.info((Object)"Building new Hibernate SessionFactory");
        this.sessionFactory = this.newSessionFactory(config);
        if (this.jtaTransactionManager != null) {
            LocalTransactionManagerLookup.configTimeTransactionManagerHolder.set(null);
        }
        if (this.dataSource != null) {
            LocalDataSourceConnectionProvider.configTimeDataSourceHolder.set(null);
        }
        if (this.lobHandler != null) {
            configTimeLobHandlerHolder.set(null);
        }
        if (this.schemaUpdate) {
            this.executeSchemaUpdate(config);
        }
    }

    protected Configuration newConfiguration() throws HibernateException {
        return new Configuration();
    }

    protected void postProcessConfiguration(Configuration config) throws HibernateException {
    }

    protected SessionFactory newSessionFactory(Configuration config) throws HibernateException {
        return config.buildSessionFactory();
    }

    protected void executeSchemaUpdate(final Configuration config) throws HibernateException {
        this.logger.info((Object)"Executing schema update for Hibernate SessionFactory");
        final Dialect dialect = Dialect.getDialect((Properties)config.getProperties());
        HibernateTemplate template = new HibernateTemplate(this.sessionFactory);
        template.execute(new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection conn = session.connection();
                DatabaseMetadata metadata = new DatabaseMetadata(conn, dialect);
                String[] sql = config.generateSchemaUpdateScript(dialect, metadata);
                Statement stmt = conn.createStatement();
                try {
                    for (int i = 0; i < sql.length; ++i) {
                        LocalSessionFactoryBean.this.logger.debug((Object)("Executing schema update statement: " + sql[i]));
                        stmt.executeUpdate(sql[i]);
                    }
                }
                finally {
                    JdbcUtils.closeStatement(stmt);
                }
                return null;
            }
        });
    }

    public Object getObject() {
        return this.sessionFactory;
    }

    public Class getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : (class$net$sf$hibernate$SessionFactory == null ? (class$net$sf$hibernate$SessionFactory = LocalSessionFactoryBean.class$("net.sf.hibernate.SessionFactory")) : class$net$sf$hibernate$SessionFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws HibernateException {
        this.logger.info((Object)"Closing Hibernate SessionFactory");
        this.sessionFactory.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

