/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$util$FileCopyUtils == null ? (class$org$springframework$util$FileCopyUtils = JdbcUtils.class$("org.springframework.util.FileCopyUtils")) : class$org$springframework$util$FileCopyUtils));
    static /* synthetic */ Class class$org$springframework$util$FileCopyUtils;

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                logger.warn((Object)"Could not close JDBC Statement", (Throwable)ex);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                logger.warn((Object)"Could not close JDBC ResultSet", (Throwable)ex);
            }
        }
    }

    public static int countParameterPlaceholders(String str, char placeholder, char delim) {
        int count = 0;
        boolean insideLiteral = false;
        for (int i = 0; str != null && i < str.length(); ++i) {
            if (str.charAt(i) == placeholder) {
                if (insideLiteral) continue;
                ++count;
                continue;
            }
            if (str.charAt(i) != delim) continue;
            insideLiteral ^= true;
        }
        return count;
    }

    public static boolean isNumeric(int sqlType) {
        return -7 == sqlType || -5 == sqlType || 3 == sqlType || 8 == sqlType || 6 == sqlType || 4 == sqlType || 2 == sqlType || 7 == sqlType || 5 == sqlType || -6 == sqlType;
    }

    public static int translateType(int sqlType) {
        int retType = sqlType;
        if (-7 == sqlType || -6 == sqlType || 5 == sqlType || 4 == sqlType) {
            retType = 4;
        } else if (1 == sqlType || 12 == sqlType) {
            retType = 12;
        } else if (3 == sqlType || 8 == sqlType || 6 == sqlType || 2 == sqlType || 7 == sqlType) {
            retType = 2;
        }
        return retType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

