/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;

public class FileSystemResource
extends AbstractResource {
    private final File file;

    public FileSystemResource(File file) {
        this.file = file;
    }

    public FileSystemResource(String path) {
        this.file = new File(path);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String getDescription() {
        return "file path [" + this.file.getAbsolutePath() + "]";
    }
}

