/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.util.WebUtils;

public class PropertiesMethodNameResolver
implements MethodNameResolver,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean alwaysUseFullPath = false;
    private Properties mappings;

    public final void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.alwaysUseFullPath = alwaysUseFullPath;
    }

    public final void setMappings(Properties mappings) {
        this.mappings = mappings;
    }

    public void afterPropertiesSet() {
        if (this.mappings == null) {
            throw new IllegalArgumentException("'mappings' property is required");
        }
        if (this.mappings.isEmpty()) {
            this.logger.warn((Object)("No mappings defined in " + this.getClass().getName()));
        }
    }

    public String getHandlerMethodName(HttpServletRequest request) throws NoSuchRequestHandlingMethodException {
        String urlPath = WebUtils.getLookupPathForRequest(request, this.alwaysUseFullPath);
        String name = this.mappings.getProperty(urlPath);
        if (name == null) {
            Iterator<Object> it = this.mappings.keySet().iterator();
            while (it.hasNext()) {
                String registeredPath = (String)it.next();
                if (!PathMatcher.match(registeredPath, urlPath)) continue;
                return (String)this.mappings.get(registeredPath);
            }
            throw new NoSuchRequestHandlingMethodException(request);
        }
        this.logger.debug((Object)("Returning MultiActionController method name '" + name + "' for lookup path '" + urlPath + "'"));
        return name;
    }
}

