/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class CommonsMultipartResolver
extends WebApplicationObjectSupport
implements MultipartResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DiskFileUpload fileUpload = this.newFileUpload();
    private File uploadTempDir;

    public CommonsMultipartResolver() {
    }

    public CommonsMultipartResolver(ServletContext servletContext) {
        this();
        this.fileUpload.setRepositoryPath(WebUtils.getTempDir(servletContext).getAbsolutePath());
    }

    protected DiskFileUpload newFileUpload() {
        return new DiskFileUpload();
    }

    public DiskFileUpload getFileUpload() {
        return this.fileUpload;
    }

    public void setMaxUploadSize(long maxUploadSize) {
        this.fileUpload.setSizeMax(maxUploadSize);
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.fileUpload.setSizeThreshold(maxInMemorySize);
    }

    public void setHeaderEncoding(String headerEncoding) {
        this.fileUpload.setHeaderEncoding(headerEncoding);
    }

    public void setUploadTempDir(Resource uploadTempDir) throws IOException {
        if (!uploadTempDir.exists() && !uploadTempDir.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + uploadTempDir + "] could not be created");
        }
        this.fileUpload.setRepositoryPath(uploadTempDir.getFile().getAbsolutePath());
        this.uploadTempDir = uploadTempDir.getFile();
    }

    protected void initApplicationContext() {
        if (this.uploadTempDir == null) {
            this.fileUpload.setRepositoryPath(this.getTempDir().getAbsolutePath());
        }
    }

    public boolean isMultipart(HttpServletRequest request) {
        return FileUploadBase.isMultipartContent((HttpServletRequest)request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        try {
            List fileItems = this.fileUpload.parseRequest(request);
            HashMap<String, String[]> parameters = new HashMap<String, String[]>();
            HashMap<String, CommonsMultipartFile> multipartFiles = new HashMap<String, CommonsMultipartFile>();
            Iterator i = fileItems.iterator();
            while (i.hasNext()) {
                FileItem fileItem = (FileItem)i.next();
                if (fileItem.isFormField()) {
                    String[] curParam = (String[])parameters.get(fileItem.getFieldName());
                    if (curParam == null) {
                        parameters.put(fileItem.getFieldName(), new String[]{fileItem.getString()});
                        continue;
                    }
                    String[] newParam = StringUtils.addStringToArray(curParam, fileItem.getString());
                    parameters.put(fileItem.getFieldName(), newParam);
                    continue;
                }
                CommonsMultipartFile file = new CommonsMultipartFile(fileItem);
                multipartFiles.put(file.getName(), file);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Found multipart file [" + file.getName() + "] of size " + file.getSize() + " bytes with original file name [" + file.getOriginalFileName() + "], stored " + file.getStorageDescription()));
            }
            return new DefaultMultipartHttpServletRequest(request, multipartFiles, parameters);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Could not parse multipart request", ex);
        }
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        Map multipartFiles = request.getFileMap();
        Iterator i = multipartFiles.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            CommonsMultipartFile file = (CommonsMultipartFile)multipartFiles.get(name);
            this.logger.debug((Object)("Cleaning up multipart file [" + file.getName() + "] with original file name [" + file.getOriginalFileName() + "], stored " + file.getStorageDescription()));
            file.getFileItem().delete();
        }
    }
}

