/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;

public class RegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements ClassFilter {
    private Log logger = LogFactory.getLog(this.getClass());
    private String pattern;
    private Pattern compiledPattern;
    private PatternMatcher matcher;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) throws MalformedPatternException {
        this.pattern = pattern;
        Perl5Compiler compiler = new Perl5Compiler();
        this.compiledPattern = compiler.compile(pattern, 32768);
        this.matcher = new Perl5Matcher();
    }

    public boolean matches(Method m, Class targetClass) {
        String patt = m.getDeclaringClass().getName() + "." + m.getName();
        boolean matched = this.matcher.matches(patt, this.compiledPattern);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Candidate is: '" + patt + "'; pattern is " + this.compiledPattern.getPattern() + "; matched=" + matched));
        }
        return matched;
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public ClassFilter getClassFilter() {
        return this;
    }
}

