/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.frame;

import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.socket.sockjs.frame.AbstractSockJsMessageCodec;
import tools.jackson.core.io.JsonStringEncoder;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonSockJsMessageCodec
extends AbstractSockJsMessageCodec {
    private final ObjectMapper objectMapper;

    public JacksonJsonSockJsMessageCodec() {
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules(JacksonJsonSockJsMessageCodec.class.getClassLoader())).build();
    }

    public JacksonJsonSockJsMessageCodec(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    @Override
    public String @Nullable [] decode(String content) {
        return (String[])this.objectMapper.readValue(content, String[].class);
    }

    @Override
    public String @Nullable [] decodeInputStream(InputStream content) {
        return (String[])this.objectMapper.readValue(content, String[].class);
    }

    @Override
    protected char[] applyJsonQuoting(String content) {
        return JsonStringEncoder.getInstance().quoteAsCharArray((CharSequence)content);
    }
}

