/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NestedCheckedException;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.sockjs.SockJsMessageDeliveryException;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.SockJsSession;

public abstract class AbstractSockJsSession
implements SockJsSession {
    public static final String DISCONNECTED_CLIENT_LOG_CATEGORY = "org.springframework.web.socket.sockjs.DisconnectedClient";
    protected static final Log disconnectedClientLogger = LogFactory.getLog((String)"org.springframework.web.socket.sockjs.DisconnectedClient");
    private static final Set<String> disconnectedClientExceptions;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Object responseLock = new Object();
    private final String id;
    private final SockJsServiceConfig config;
    private final WebSocketHandler handler;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private volatile State state = State.NEW;
    private final long timeCreated;
    private volatile long timeLastActive = this.timeCreated = System.currentTimeMillis();
    private ScheduledFuture<?> heartbeatFuture;
    private HeartbeatTask heartbeatTask;
    private volatile boolean heartbeatDisabled;

    public AbstractSockJsSession(String id, SockJsServiceConfig config, WebSocketHandler handler, Map<String, Object> attributes) {
        Assert.notNull((Object)id, (String)"SessionId must not be null");
        Assert.notNull((Object)config, (String)"SockJsConfig must not be null");
        Assert.notNull((Object)handler, (String)"WebSocketHandler must not be null");
        this.id = id;
        this.config = config;
        this.handler = handler;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected SockJsMessageCodec getMessageCodec() {
        return this.config.getMessageCodec();
    }

    public SockJsServiceConfig getSockJsServiceConfig() {
        return this.config;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public final void sendMessage(WebSocketMessage<?> message) throws IOException {
        Assert.state((!this.isClosed() ? 1 : 0) != 0, (String)"Cannot send a message when session is closed");
        Assert.isInstanceOf(TextMessage.class, message, (String)"SockJS supports text messages only");
        this.sendMessageInternal((String)((TextMessage)message).getPayload());
    }

    protected abstract void sendMessageInternal(String var1) throws IOException;

    public boolean isNew() {
        return State.NEW.equals((Object)this.state);
    }

    @Override
    public boolean isOpen() {
        return State.OPEN.equals((Object)this.state);
    }

    public boolean isClosed() {
        return State.CLOSED.equals((Object)this.state);
    }

    @Override
    public final void close() throws IOException {
        this.close(new CloseStatus(3000, "Go away!"));
    }

    @Override
    public final void close(CloseStatus status) throws IOException {
        if (this.isOpen()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing SockJS session " + this.getId() + " with " + status));
            }
            this.state = State.CLOSED;
            try {
                if (this.isActive() && !CloseStatus.SESSION_NOT_RELIABLE.equals(status)) {
                    try {
                        this.writeFrameInternal(SockJsFrame.closeFrame(status.getCode(), status.getReason()));
                    }
                    catch (Throwable ex) {
                        this.logger.debug((Object)"Failure while sending SockJS close frame", ex);
                    }
                }
                this.updateLastActiveTime();
                this.cancelHeartbeat();
                this.disconnect(status);
            }
            finally {
                try {
                    this.handler.afterConnectionClosed(this, status);
                }
                catch (Throwable ex) {
                    this.logger.debug((Object)("Error from WebSocketHandler.afterConnectionClosed in " + this), ex);
                }
            }
        }
    }

    @Override
    public long getTimeSinceLastActive() {
        if (this.isNew()) {
            return System.currentTimeMillis() - this.timeCreated;
        }
        return this.isActive() ? 0L : System.currentTimeMillis() - this.timeLastActive;
    }

    protected void updateLastActiveTime() {
        this.timeLastActive = System.currentTimeMillis();
    }

    @Override
    public void disableHeartbeat() {
        this.heartbeatDisabled = true;
        this.cancelHeartbeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeartbeat() throws SockJsTransportFailureException {
        Object object = this.responseLock;
        synchronized (object) {
            if (this.isActive() && !this.heartbeatDisabled) {
                this.writeFrame(SockJsFrame.heartbeatFrame());
                this.scheduleHeartbeat();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleHeartbeat() {
        if (this.heartbeatDisabled) {
            return;
        }
        Object object = this.responseLock;
        synchronized (object) {
            this.cancelHeartbeat();
            if (!this.isActive()) {
                return;
            }
            Date time = new Date(System.currentTimeMillis() + this.config.getHeartbeatTime());
            this.heartbeatTask = new HeartbeatTask();
            this.heartbeatFuture = this.config.getTaskScheduler().schedule((Runnable)this.heartbeatTask, time);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Scheduled heartbeat in session " + this.getId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelHeartbeat() {
        Object object = this.responseLock;
        synchronized (object) {
            if (this.heartbeatFuture != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Cancelling heartbeat in session " + this.getId()));
                }
                this.heartbeatFuture.cancel(false);
                this.heartbeatFuture = null;
            }
            if (this.heartbeatTask != null) {
                this.heartbeatTask.cancel();
                this.heartbeatTask = null;
            }
        }
    }

    public abstract boolean isActive();

    protected abstract void disconnect(CloseStatus var1) throws IOException;

    protected void writeFrame(SockJsFrame frame) throws SockJsTransportFailureException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Preparing to write " + frame));
        }
        try {
            this.writeFrameInternal(frame);
        }
        catch (Throwable ex) {
            this.logWriteFrameFailure(ex);
            try {
                this.disconnect(CloseStatus.SERVER_ERROR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.close(CloseStatus.SERVER_ERROR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new SockJsTransportFailureException("Failed to write " + frame, this.getId(), ex);
        }
    }

    private void logWriteFrameFailure(Throwable failure) {
        NestedCheckedException nestedException = new NestedCheckedException("", failure){};
        if ("Broken pipe".equalsIgnoreCase(nestedException.getMostSpecificCause().getMessage()) || disconnectedClientExceptions.contains(failure.getClass().getSimpleName())) {
            if (disconnectedClientLogger.isTraceEnabled()) {
                disconnectedClientLogger.trace((Object)"Looks like the client has gone away", failure);
            } else if (disconnectedClientLogger.isDebugEnabled()) {
                disconnectedClientLogger.debug((Object)("Looks like the client has gone away: " + nestedException.getMessage() + " (For full stack trace, set the '" + DISCONNECTED_CLIENT_LOG_CATEGORY + "' log category to TRACE level)"));
            }
        } else {
            this.logger.debug((Object)"Terminating connection after failure to send message to client", failure);
        }
    }

    protected abstract void writeFrameInternal(SockJsFrame var1) throws IOException;

    public void delegateConnectionEstablished() throws Exception {
        this.state = State.OPEN;
        this.handler.afterConnectionEstablished(this);
    }

    public void delegateMessages(String ... messages) throws SockJsMessageDeliveryException {
        ArrayList<String> undelivered = new ArrayList<String>(Arrays.asList(messages));
        for (String message : messages) {
            try {
                if (this.isClosed()) {
                    throw new SockJsMessageDeliveryException(this.id, undelivered, "Session closed");
                }
                this.handler.handleMessage(this, new TextMessage(message));
                undelivered.remove(0);
            }
            catch (Throwable ex) {
                throw new SockJsMessageDeliveryException(this.id, undelivered, ex);
            }
        }
    }

    public final void delegateConnectionClosed(CloseStatus status) throws Exception {
        if (!this.isClosed()) {
            try {
                this.updateLastActiveTime();
                ScheduledFuture<?> future = this.heartbeatFuture;
                if (future != null) {
                    this.heartbeatFuture = null;
                    future.cancel(false);
                }
            }
            finally {
                this.state = State.CLOSED;
                this.handler.afterConnectionClosed(this, status);
            }
        }
    }

    public void tryCloseWithSockJsTransportError(Throwable error, CloseStatus closeStatus) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing due to transport error for " + this));
        }
        try {
            this.delegateError(error);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.close(closeStatus);
        }
        catch (Throwable closeException) {
            this.logger.debug((Object)("Failure while closing " + this), closeException);
        }
    }

    public void delegateError(Throwable ex) throws Exception {
        this.handler.handleTransportError(this, ex);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "]";
    }

    static {
        HashSet<String> set = new HashSet<String>(4);
        set.add("ClientAbortException");
        set.add("EOFException");
        set.add("EofException");
        disconnectedClientExceptions = Collections.unmodifiableSet(set);
    }

    private class HeartbeatTask
    implements Runnable {
        private boolean expired;

        private HeartbeatTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AbstractSockJsSession.this.responseLock;
            synchronized (object) {
                if (!this.expired && !AbstractSockJsSession.this.isClosed()) {
                    try {
                        AbstractSockJsSession.this.sendHeartbeat();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.expired = true;
                    }
                }
            }
        }

        void cancel() {
            this.expired = true;
        }
    }

    private static enum State {
        NEW,
        OPEN,
        CLOSED;

    }
}

