/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import java.util.Arrays;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.SockJsServiceRegistration;
import org.springframework.web.socket.config.annotation.StompWebSocketEndpointRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.SockJsService;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.springframework.web.socket.sockjs.transport.handler.WebSocketTransportHandler;

public class WebMvcStompWebSocketEndpointRegistration
implements StompWebSocketEndpointRegistration {
    private final String[] paths;
    private final WebSocketHandler webSocketHandler;
    private final TaskScheduler sockJsTaskScheduler;
    private HandshakeHandler handshakeHandler;
    private HandshakeInterceptor[] interceptors;
    private StompSockJsServiceRegistration registration;

    public WebMvcStompWebSocketEndpointRegistration(String[] paths, WebSocketHandler webSocketHandler, TaskScheduler sockJsTaskScheduler) {
        Assert.notEmpty((Object[])paths, (String)"No paths specified");
        Assert.notNull((Object)webSocketHandler, (String)"WebSocketHandler must not be null");
        this.paths = paths;
        this.webSocketHandler = webSocketHandler;
        this.sockJsTaskScheduler = sockJsTaskScheduler;
    }

    @Override
    public StompWebSocketEndpointRegistration setHandshakeHandler(HandshakeHandler handshakeHandler) {
        Assert.notNull((Object)handshakeHandler, (String)"'handshakeHandler' must not be null");
        this.handshakeHandler = handshakeHandler;
        return this;
    }

    @Override
    public StompWebSocketEndpointRegistration addInterceptors(HandshakeInterceptor ... interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    protected HandshakeInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    @Override
    public SockJsServiceRegistration withSockJS() {
        this.registration = new StompSockJsServiceRegistration(this.sockJsTaskScheduler);
        if (this.interceptors != null) {
            this.registration.setInterceptors(this.interceptors);
        }
        if (this.handshakeHandler != null) {
            WebSocketTransportHandler transportHandler = new WebSocketTransportHandler(this.handshakeHandler);
            this.registration.setTransportHandlerOverrides(transportHandler);
        }
        return this.registration;
    }

    public final MultiValueMap<HttpRequestHandler, String> getMappings() {
        LinkedMultiValueMap mappings = new LinkedMultiValueMap();
        if (this.registration != null) {
            SockJsService sockJsService = this.registration.getSockJsService();
            for (String path : this.paths) {
                String pattern = path.endsWith("/") ? path + "**" : path + "/**";
                SockJsHttpRequestHandler handler = new SockJsHttpRequestHandler(sockJsService, this.webSocketHandler);
                mappings.add((Object)handler, (Object)pattern);
            }
        } else {
            for (String path : this.paths) {
                WebSocketHttpRequestHandler handler = this.handshakeHandler != null ? new WebSocketHttpRequestHandler(this.webSocketHandler, this.handshakeHandler) : new WebSocketHttpRequestHandler(this.webSocketHandler);
                if (this.interceptors != null) {
                    handler.setHandshakeInterceptors(Arrays.asList(this.interceptors));
                }
                mappings.add((Object)handler, (Object)path);
            }
        }
        return mappings;
    }

    private static class StompSockJsServiceRegistration
    extends SockJsServiceRegistration {
        public StompSockJsServiceRegistration(TaskScheduler defaultTaskScheduler) {
            super(defaultTaskScheduler);
        }

        @Override
        protected SockJsService getSockJsService() {
            return super.getSockJsService();
        }
    }
}

