/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindException;
import org.springframework.web.ErrorResponse;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

public class DefaultHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");

    public DefaultHandlerExceptionResolver() {
        this.setOrder(Integer.MAX_VALUE);
        this.setWarnLogCategory(this.getClass().getName());
    }

    @Override
    @Nullable
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        block28: {
            try {
                if (ex instanceof ErrorResponse) {
                    ModelAndView mav = null;
                    if (ex instanceof HttpRequestMethodNotSupportedException) {
                        mav = this.handleHttpRequestMethodNotSupported((HttpRequestMethodNotSupportedException)ex, request, response, handler);
                    } else if (ex instanceof HttpMediaTypeNotSupportedException) {
                        mav = this.handleHttpMediaTypeNotSupported((HttpMediaTypeNotSupportedException)ex, request, response, handler);
                    } else if (ex instanceof HttpMediaTypeNotAcceptableException) {
                        mav = this.handleHttpMediaTypeNotAcceptable((HttpMediaTypeNotAcceptableException)((Object)ex), request, response, handler);
                    } else if (ex instanceof MissingPathVariableException) {
                        mav = this.handleMissingPathVariable((MissingPathVariableException)ex, request, response, handler);
                    } else if (ex instanceof MissingServletRequestParameterException) {
                        mav = this.handleMissingServletRequestParameter((MissingServletRequestParameterException)ex, request, response, handler);
                    } else if (ex instanceof MissingServletRequestPartException) {
                        mav = this.handleMissingServletRequestPartException((MissingServletRequestPartException)ex, request, response, handler);
                    } else if (ex instanceof ServletRequestBindingException) {
                        mav = this.handleServletRequestBindingException((ServletRequestBindingException)ex, request, response, handler);
                    } else if (ex instanceof MethodArgumentNotValidException) {
                        mav = this.handleMethodArgumentNotValidException((MethodArgumentNotValidException)ex, request, response, handler);
                    } else if (ex instanceof NoHandlerFoundException) {
                        mav = this.handleNoHandlerFoundException((NoHandlerFoundException)((Object)ex), request, response, handler);
                    } else if (ex instanceof AsyncRequestTimeoutException) {
                        mav = this.handleAsyncRequestTimeoutException((AsyncRequestTimeoutException)ex, request, response, handler);
                    }
                    if (mav == null) {
                        return this.handleErrorResponse((ErrorResponse)ex, request, response, handler);
                    }
                }
                if (ex instanceof ConversionNotSupportedException) {
                    return this.handleConversionNotSupported((ConversionNotSupportedException)ex, request, response, handler);
                }
                if (ex instanceof TypeMismatchException) {
                    return this.handleTypeMismatch((TypeMismatchException)ex, request, response, handler);
                }
                if (ex instanceof HttpMessageNotReadableException) {
                    return this.handleHttpMessageNotReadable((HttpMessageNotReadableException)ex, request, response, handler);
                }
                if (ex instanceof HttpMessageNotWritableException) {
                    return this.handleHttpMessageNotWritable((HttpMessageNotWritableException)ex, request, response, handler);
                }
                if (ex instanceof BindException) {
                    return this.handleBindException((BindException)ex, request, response, handler);
                }
            }
            catch (Exception handlerEx) {
                if (!this.logger.isWarnEnabled()) break block28;
                this.logger.warn((Object)("Failure while trying to resolve exception [" + ex.getClass().getName() + "]"), (Throwable)handlerEx);
            }
        }
        return null;
    }

    @Nullable
    protected ModelAndView handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleMissingPathVariable(MissingPathVariableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleMissingServletRequestPartException(MissingServletRequestPartException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleServletRequestBindingException(ServletRequestBindingException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleNoHandlerFoundException(NoHandlerFoundException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        return null;
    }

    @Nullable
    protected ModelAndView handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    protected ModelAndView handleErrorResponse(ErrorResponse errorResponse, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        if (!response.isCommitted()) {
            HttpHeaders headers = errorResponse.getHeaders();
            headers.forEach((name, values) -> values.forEach(value -> response.addHeader(name, value)));
            int status = errorResponse.getStatusCode().value();
            String message = errorResponse.getBody().getDetail();
            if (message != null) {
                response.sendError(status, message);
            } else {
                response.sendError(status);
            }
        } else {
            this.logger.warn((Object)("Ignoring exception, response committed. : " + errorResponse));
        }
        return new ModelAndView();
    }

    protected ModelAndView handleConversionNotSupported(ConversionNotSupportedException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        this.sendServerError((Exception)ex, request, response);
        return new ModelAndView();
    }

    protected ModelAndView handleTypeMismatch(TypeMismatchException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        response.sendError(400);
        return new ModelAndView();
    }

    protected ModelAndView handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        response.sendError(400);
        return new ModelAndView();
    }

    protected ModelAndView handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        this.sendServerError((Exception)ex, request, response);
        return new ModelAndView();
    }

    protected ModelAndView handleBindException(BindException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        response.sendError(400);
        return new ModelAndView();
    }

    protected void sendServerError(Exception ex, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("jakarta.servlet.error.exception", (Object)ex);
        response.sendError(500);
    }
}

